/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.statet.internal.r.ui.editors.RArgumentListContextInformation;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistCompletionInformationProposalWrapper;
import org.eclipse.statet.r.core.model.ArgsDefinition;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RScanner;
import org.eclipse.swt.custom.StyleRange;

public class RContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private ITextViewer fViewer;
    private int fStartOffset;
    private IContextInformation fInfo;
    private RArgumentListContextInformation fArgInfo;
    private int fCurrentParameter;
    private long fScannedArgsStamp;
    private FCall.Args fScannedArgs;
    private int fLastPresentation = -2;

    public boolean isContextInformationValid(int offset) {
        FCall.Args args;
        if (this.fInfo == null) {
            return false;
        }
        IDocument document = this.fViewer.getDocument();
        if (offset < this.fStartOffset || offset > document.getLength()) {
            return false;
        }
        if (this.fArgInfo != null && (args = this.getScannedArgs()) != null) {
            return offset <= args.getEndOffset();
        }
        return offset == this.fStartOffset;
    }

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        if (info instanceof AssistCompletionInformationProposalWrapper) {
            info = ((AssistCompletionInformationProposalWrapper)info).getContextInformation();
        }
        this.fScannedArgs = null;
        this.fLastPresentation = -2;
        if (!(info instanceof RArgumentListContextInformation)) {
            this.fInfo = info;
            this.fArgInfo = null;
            return;
        }
        this.fArgInfo = (RArgumentListContextInformation)info;
        this.fInfo = this.fArgInfo;
        this.fCurrentParameter = -1;
        this.fViewer = viewer;
        this.fStartOffset = offset;
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        ArgsDefinition args;
        if (this.fArgInfo != null && (args = this.fArgInfo.getArguments()) != null && args.size() > 0) {
            int argIndex = this.getCurrentArgInFDef(offset);
            int[] idxs = this.fArgInfo.getInformationDisplayStringArgumentIdxs();
            if (argIndex >= 0 && argIndex < idxs.length) {
                if (argIndex == this.fLastPresentation) {
                    return false;
                }
                int start = idxs[argIndex];
                int stop = argIndex + 1 < idxs.length ? idxs[argIndex + 1] : this.fArgInfo.getInformationDisplayString().length();
                presentation.clear();
                presentation.addStyleRange(new StyleRange(start, stop - start, null, null, 1));
                this.fLastPresentation = argIndex;
                return true;
            }
        }
        if (this.fLastPresentation == -1) {
            return false;
        }
        presentation.clear();
        presentation.addStyleRange(new StyleRange(0, this.fInfo.getInformationDisplayString().length(), null, null, 0));
        this.fLastPresentation = -1;
        return true;
    }

    private FCall.Args getScannedArgs() {
        AbstractDocument document = (AbstractDocument)this.fViewer.getDocument();
        long stamp = document.getModificationStamp();
        if (this.fScannedArgs == null || this.fScannedArgsStamp != stamp) {
            try {
                String text = document.get(this.fStartOffset, Math.min(2048, document.getLength() - this.fStartOffset));
                RScanner scanner = new RScanner(4);
                this.fScannedArgs = scanner.scanFCallArgs(new OffsetStringParserInput(text, this.fStartOffset).init(this.fStartOffset, this.fStartOffset + text.length()), true);
                this.fScannedArgsStamp = stamp;
            }
            catch (Exception e) {
                this.fScannedArgs = null;
            }
        }
        return this.fScannedArgs;
    }

    private int getCurrentArgInFDef(int offset) {
        RAst.FCallArgMatch match;
        ArgsDefinition.Arg argDef;
        int callArgIdx = this.getCurrentArgInFCall(offset);
        if (callArgIdx >= 0 && (argDef = (match = RAst.matchArgs((FCall.Args)this.getScannedArgs(), (ArgsDefinition)this.fArgInfo.getArguments())).getArgDef(callArgIdx)) != null) {
            return argDef.index;
        }
        return -1;
    }

    private int getCurrentArgInFCall(int offset) {
        FCall.Args args = this.getScannedArgs();
        if (args != null) {
            int last = args.getChildCount() - 1;
            if (last == -1) {
                return 0;
            }
            int i = 0;
            while (i < last) {
                if (offset <= args.getSeparatorOffset(i)) {
                    return i;
                }
                ++i;
            }
            return last;
        }
        return -1;
    }
}

