/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRLangElement;
import org.eclipse.statet.r.core.model.RElementName;

public class ExportedRElement
implements IRLangElement,
Serializable {
    private static final long serialVersionUID = -493469386405499748L;
    private IRLangElement parent;
    private int elementType;
    private RElementName elementName;
    private String elementId;
    private int sourceOffset;
    private int sourceLength;
    private int nameOffset;
    private int nameLength;

    static final List<? extends IRLangElement> getChildren(List<? extends IRLangElement> children, IModelElement.Filter filter) {
        if (filter == null) {
            return children;
        }
        ArrayList<IRLangElement> filtered = new ArrayList<IRLangElement>(children.size());
        for (IRLangElement iRLangElement : children) {
            if (!filter.include((IModelElement)iRLangElement)) continue;
            filtered.add(iRLangElement);
        }
        return filtered;
    }

    static final boolean hasChildren(List<? extends IRLangElement> children, IModelElement.Filter filter) {
        if (filter == null) {
            return !children.isEmpty();
        }
        for (IRElement iRElement : children) {
            if (!filter.include((IModelElement)iRElement)) continue;
            return true;
        }
        return false;
    }

    public ExportedRElement(IRLangElement parent, IRLangElement sourceElement) {
        this.parent = parent;
        this.elementType = sourceElement.getElementType();
        this.elementName = RElementName.cloneName(sourceElement.getElementName(), false);
        this.elementId = sourceElement.getId();
        TextRegion sourceRange = sourceElement.getSourceRange();
        if (sourceRange != null) {
            this.sourceOffset = sourceRange.getStartOffset();
            this.sourceLength = sourceRange.getLength();
        } else {
            this.sourceOffset = -1;
        }
        sourceRange = sourceElement.getNameSourceRange();
        if (sourceRange != null) {
            this.nameOffset = sourceRange.getStartOffset();
            this.nameLength = sourceRange.getLength();
        } else {
            this.nameOffset = -1;
        }
    }

    public ExportedRElement() {
    }

    public String getModelTypeId() {
        return "R";
    }

    public String getId() {
        return this.elementId;
    }

    public int getElementType() {
        return this.elementType;
    }

    @Override
    public RElementName getElementName() {
        return this.elementName;
    }

    public boolean exists() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public IRElement getModelParent() {
        return this.parent;
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        return false;
    }

    @Override
    public List<? extends IRLangElement> getModelChildren(IModelElement.Filter filter) {
        return Collections.EMPTY_LIST;
    }

    public ISourceUnit getSourceUnit() {
        return this.parent.getSourceUnit();
    }

    public TextRegion getSourceRange() {
        if (this.sourceOffset >= 0) {
            return new BasicTextRegion(this.sourceOffset, this.sourceOffset + this.sourceLength);
        }
        return null;
    }

    public TextRegion getNameSourceRange() {
        if (this.nameOffset >= 0) {
            return new BasicTextRegion(this.nameOffset, this.nameOffset + this.nameLength);
        }
        return null;
    }

    public TextRegion getDocumentationRange() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        return null;
    }
}

