/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model;

import java.util.Comparator;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

@NonNullByDefault
public abstract class RElementAccess
extends RElementName {
    public static final Comparator<RElementAccess> NAME_POSITION_COMPARATOR = new Comparator<RElementAccess>(){

        private int comparePosition(@Nullable RAstNode n1, @Nullable RAstNode n2) {
            if (n1 != null) {
                if (n2 != null) {
                    return n1.getStartOffset() - n2.getStartOffset();
                }
                return -1;
            }
            if (n2 != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public int compare(RElementAccess o1, RElementAccess o2) {
            int offset = this.comparePosition(o1.getNameNode(), o2.getNameNode());
            while (offset == 0) {
                o1 = o1.getNextSegment();
                o2 = o2.getNextSegment();
                if (o1 != null) {
                    if (o2 != null) {
                        offset = this.comparePosition(o1.getNameNode(), o2.getNameNode());
                        continue;
                    }
                    return 1;
                }
                if (o2 != null) {
                    return -1;
                }
                return 0;
            }
            return offset;
        }
    };

    public static @Nullable RElementAccess getMainElementAccessOfNameNode(RAstNode nameNode) {
        RAstNode node = nameNode;
        while (node != null) {
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                if (!(attachment instanceof RElementAccess)) continue;
                RElementAccess access = (RElementAccess)attachment;
                do {
                    if (!access.isMaster() || access.getNameNode() != nameNode) continue;
                    return (RElementAccess)attachment;
                } while ((access = access.getNextSegment()) != null);
            }
            node = node.getRParent();
        }
        return null;
    }

    public static @Nullable RElementAccess getElementAccessOfNameNode(RAstNode nameNode) {
        RAstNode node = nameNode;
        while (node != null) {
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                if (!(attachment instanceof RElementAccess)) continue;
                RElementAccess access = (RElementAccess)attachment;
                do {
                    if (!access.isMaster() || access.getNameNode() != nameNode) continue;
                    return access;
                } while ((access = access.getNextSegment()) != null);
            }
            node = node.getRParent();
        }
        return null;
    }

    public abstract IRFrame getFrame();

    public abstract boolean isWriteAccess();

    public abstract boolean isFunctionAccess();

    public abstract boolean isCallAccess();

    public boolean isMaster() {
        return true;
    }

    public boolean isSlave() {
        return false;
    }

    public RElementAccess getMaster() {
        return this;
    }

    public abstract RAstNode getNode();

    public abstract @Nullable RAstNode getNameNode();

    @Override
    public abstract @Nullable RElementAccess getNextSegment();

    @Override
    public RElementAccess getLastSegment() {
        RElementAccess lastSegment;
        RElementAccess nextSegment = this;
        do {
            lastSegment = nextSegment;
        } while ((nextSegment = nextSegment.getNextSegment()) != null);
        return lastSegment;
    }

    public abstract ImList<? extends RElementAccess> getAllInUnit(boolean var1);
}

