/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rhelp.core.update.REnvIndexUpdater;
import org.eclipse.statet.rj.renv.runtime.RPkgManager;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class WorkbenchREnvIndexUpdater
extends REnvIndexUpdater {
    public WorkbenchREnvIndexUpdater(REnvHelpConfiguration rEnvConfig, RHelpManager rHelpManager, RPkgManager rPkgManager) {
        super(rEnvConfig, rHelpManager, rPkgManager);
    }

    protected REnvIndexUpdater.IndexJob scheduleIndexJob(String name) {
        return new WorkbenchIndexJob(name);
    }

    protected Path toLocalPath(String rPath, RService r, ProgressMonitor m) throws StatusException {
        if (r instanceof IRBasicAdapter) {
            try {
                IFileStore fileStore = ((IRBasicAdapter)r).getWorkspaceData().toFileStore(rPath);
                return Paths.get(fileStore.toURI());
            }
            catch (CoreException e) {
                throw StatusUtils.convert((CoreException)e);
            }
        }
        return super.toLocalPath(rPath, r, m);
    }

    private class WorkbenchIndexJob
    extends REnvIndexUpdater.IndexJob {
        private final Job workbenchJob;

        public WorkbenchIndexJob(String name) {
            super((REnvIndexUpdater)WorkbenchREnvIndexUpdater.this);
            this.workbenchJob = new Job(name){

                protected IStatus run(IProgressMonitor monitor) {
                    return StatusUtils.convert((Status)WorkbenchIndexJob.this.run(StatusUtils.convert((IProgressMonitor)monitor)));
                }
            };
            this.workbenchJob.setPriority(30);
            this.workbenchJob.setSystem(true);
            this.workbenchJob.schedule();
        }

        protected void cancel() {
            this.workbenchJob.cancel();
        }

        protected void join() {
            while (true) {
                try {
                    this.workbenchJob.join();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

