/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.util.MenuUtils;
import org.eclipse.statet.internal.ecommons.ui.AccessibleArrowImage;
import org.eclipse.statet.internal.ecommons.ui.UIMiscellanyPlugin;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class DropDownButton
extends Composite {
    private Button mainButton;
    private Button downButton;
    private Image image;
    private Image disabledImage;
    private Point imageButtonDefaultSize;
    private String arrowText;
    private Menu menu;
    private final CopyOnWriteIdentityListSet<MenuListener> menuListener = new CopyOnWriteIdentityListSet();

    public DropDownButton(Composite parent) {
        this(parent, 0);
    }

    public DropDownButton(Composite parent, int style) {
        super(parent, 0);
        this.create(style);
    }

    private void create(int style) {
        boolean single = (style & 4) != 0;
        int buttonStyle = style & 0xFFFFFFFB;
        this.downButton = new Button((Composite)this, 8 | buttonStyle);
        AccessibleArrowImage imageDescriptor = new AccessibleArrowImage(1024, -1, this.downButton.getForeground().getRGB(), this.downButton.getBackground().getRGB());
        this.image = UIMiscellanyPlugin.getInstance().getImageDescriptorRegistry().get((ImageDescriptor)imageDescriptor);
        this.updateSizes();
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = DropDownButton.this.getDropDownMenu();
                MenuUtils.setPullDownPosition(menu, (Control)DropDownButton.this);
                menu.setVisible(true);
            }
        });
        if (single) {
            this.setTabList(new Control[]{this.downButton});
        } else {
            this.mainButton = new Button((Composite)this, 8 | buttonStyle);
            this.setTabList(new Control[]{this.mainButton, this.downButton});
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        DropDownButton.this.doDispose();
                        return;
                    }
                    case 11: {
                        DropDownButton.this.updateBounds(event);
                        return;
                    }
                    case 9: {
                        DropDownButton.this.paintButton(event);
                        return;
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(11, listener);
        this.downButton.addListener(9, listener);
    }

    protected void doDispose() {
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
            this.disabledImage = null;
        }
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    private void updateSizes() {
        Button button = new Button((Composite)this, 8);
        button.setImage(this.image);
        button.setFont(this.getFont());
        this.imageButtonDefaultSize = button.computeSize(-1, -1);
        button.dispose();
        if (this.mainButton == null) {
            int imageWidth = this.image.getBounds().width;
            int requiredWidth = imageWidth + (this.imageButtonDefaultSize.x - imageWidth + 1) / 2;
            GC gc = new GC((Drawable)this);
            String text = " ";
            int i = 1;
            while (i < 10) {
                if (gc.stringExtent((String)text).x >= requiredWidth) break;
                text = String.valueOf(text) + " ";
                ++i;
            }
            this.arrowText = text;
        }
    }

    private void updateBounds(Event event) {
        Rectangle clientArea = this.getClientArea();
        if (this.mainButton != null) {
            int downButtonWidth = this.imageButtonDefaultSize.x;
            this.mainButton.setBounds(clientArea.x, clientArea.y, clientArea.width - downButtonWidth + 1, clientArea.height);
            this.downButton.setBounds(clientArea.x + clientArea.width - downButtonWidth, clientArea.y, downButtonWidth, clientArea.height);
        } else {
            this.downButton.setBounds(clientArea);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point downSize = this.downButton.computeSize(-1, hHint);
        int width = downSize.x;
        int height = downSize.y;
        if (this.mainButton != null) {
            Point mainSize = wHint == -1 ? this.mainButton.computeSize(-1, hHint) : this.mainButton.computeSize(Math.max(0, wHint - downSize.x), hHint);
            width += mainSize.x - 1;
            height = Math.max(mainSize.y, height);
        }
        Rectangle trim = super.computeTrim(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    private Image getDisabledImage() {
        if (this.disabledImage == null) {
            this.disabledImage = new Image(this.image.getDevice(), this.image, 1);
        }
        return this.disabledImage;
    }

    private void paintButton(Event event) {
        Point buttonSize = this.downButton.getSize();
        Image image = this.downButton.isEnabled() ? this.image : this.getDisabledImage();
        event.gc.drawImage(image, this.mainButton != null ? (buttonSize.x - image.getBounds().width) / 2 : buttonSize.x - this.imageButtonDefaultSize.x + (this.imageButtonDefaultSize.x - image.getBounds().width) / 2, (buttonSize.y - image.getBounds().height) / 2);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateSizes();
    }

    public void setEnabled(boolean enabled) {
        if (this.mainButton != null) {
            this.mainButton.setEnabled(enabled);
        }
        this.downButton.setEnabled(enabled);
    }

    public void setText(String string) {
        if (this.mainButton != null) {
            this.mainButton.setText(string);
        } else {
            this.downButton.setText(String.valueOf(string) + this.arrowText);
        }
    }

    public void setToolTipText(String string) {
        if (this.mainButton != null) {
            this.mainButton.setToolTipText(string);
        } else {
            this.downButton.setToolTipText(string);
        }
    }

    public void setOptionToolTipText(String string) {
        this.downButton.setToolTipText(string);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.mainButton.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.mainButton.removeSelectionListener(listener);
    }

    public void addMenuListener(MenuListener listener) {
        this.menuListener.add((Object)listener);
        if (this.menu != null) {
            this.menuListener.add((Object)listener);
        }
    }

    public void removeMenuListener(MenuListener listener) {
        this.menuListener.remove((Object)listener);
        if (this.menu != null) {
            this.menuListener.remove((Object)listener);
        }
    }

    public Menu getDropDownMenu() {
        Menu menu = this.menu;
        if (menu == null) {
            menu = this.createDropDownMenu();
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            if (DropDownButton.this.menu == event.widget) {
                                DropDownButton.this.menu = null;
                            }
                            return;
                        }
                    }
                }
            };
            menu.addListener(12, listener);
            for (MenuListener menuListener : this.menuListener) {
                menu.addMenuListener(menuListener);
            }
            this.menu = menu;
        }
        return menu;
    }

    protected Menu createDropDownMenu() {
        return new Menu((Control)this);
    }
}

