/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util;

import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.util.Graphic;

public class PdfGraphic
extends Graphic {
    @Override
    public void setSize(double width, double height, String unit) {
        if ("px".equals(unit)) {
            throw new IllegalArgumentException("Pixel not supported by PDF graphic.");
        }
        super.setSize(width, height, unit);
    }

    @Override
    protected void prepare(String filename, RService service, ProgressMonitor m) throws StatusException {
        FunctionCall png = service.createFunctionCall("pdf");
        png.addChar("file", filename);
        if (this.resolution > 0) {
            png.addInt("res", this.resolution);
        }
        if (this.sizeUnit != null) {
            if (this.sizeUnit.equals("in")) {
                png.addNum("width", this.sizeWidth);
                png.addNum("height", this.sizeHeight);
            } else if (this.sizeUnit.equals("cm")) {
                png.addNum("width", this.sizeWidth / 2.54);
                png.addNum("height", this.sizeHeight / 2.54);
            } else if (this.sizeUnit.equals("mm")) {
                png.addNum("width", this.sizeWidth / 25.4);
                png.addNum("height", this.sizeHeight / 25.4);
            }
        }
        png.evalVoid(m);
    }
}

