/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.statet.internal.rhelp.core.REnvHelpIndex;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexReader;
import org.eclipse.statet.internal.rhelp.core.server.ServerClientSupport;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.DocResource;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpKeywordGroup;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;
import org.eclipse.statet.rhelp.core.RHelpSearchRequestor;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.REnv;

@NonNullByDefault
public final class REnvHelpImpl
implements REnvHelp {
    public static final long NOT_AVAILABLE_STAMP = 0L;
    private final REnv rEnv;
    private final long stamp;
    private final @Nullable String docDir;
    private final ImList<DocResource> manuals;
    private final ImList<DocResource> miscRes;
    private final ImList<RHelpKeywordGroup> keywords;
    private final ImList<RPkgHelp> packages;
    private volatile @Nullable Map<String, RPkgHelp> packageMap;
    private volatile @Nullable REnvHelpIndex index;
    private boolean disposed;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public static long createStamp() {
        long stamp = System.currentTimeMillis();
        if (stamp == 0L) {
            ++stamp;
        }
        return stamp;
    }

    public REnvHelpImpl(REnv rEnv, long stamp, @Nullable String docDir, ImList<DocResource> manuals, ImList<DocResource> miscRes, ImList<RHelpKeywordGroup> keywords, ImList<RPkgHelp> packages) {
        this.rEnv = rEnv;
        this.stamp = stamp;
        this.docDir = docDir;
        this.manuals = manuals;
        this.miscRes = miscRes;
        this.keywords = keywords;
        this.packages = packages;
    }

    public void dispose() {
        this.lock.writeLock().lock();
        try {
            this.disposed = true;
            this.packageMap = null;
            if (this.index != null) {
                this.index.dispose();
                this.index = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public REnv getREnv() {
        return this.rEnv;
    }

    public long getStamp() {
        return this.stamp;
    }

    public @Nullable String getDocDir() {
        return this.docDir;
    }

    public void lock() {
        this.lock.readLock().lock();
    }

    @Override
    public void unlock() {
        this.lock.readLock().unlock();
    }

    @Override
    public ImList<DocResource> getManuals() {
        return this.manuals;
    }

    @Override
    public ImList<DocResource> getMiscResources() {
        return this.miscRes;
    }

    @Override
    public ImList<RHelpKeywordGroup> getKeywords() {
        return this.keywords;
    }

    @Override
    public ImList<RPkgHelp> getPkgs() {
        return this.packages;
    }

    @Override
    public @Nullable RPkgHelp getPkgHelp(String pkgName) {
        return this.getPackageMap().get(pkgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RPkgHelp> getPackageMap() {
        Map<String, RPkgHelp> map = this.packageMap;
        if (map == null) {
            REnvHelpImpl rEnvHelpImpl = this;
            synchronized (rEnvHelpImpl) {
                if (this.disposed) {
                    throw new IllegalStateException("This help index is no longer valid.");
                }
                map = this.packageMap;
                if (map == null) {
                    map = new HashMap<String, RPkgHelp>(this.packages.size());
                    for (RPkgHelp pkgHelp : this.packages) {
                        map.put(pkgHelp.getName(), pkgHelp);
                    }
                    this.packageMap = map;
                }
            }
        }
        return map;
    }

    synchronized void setIndex(REnvHelpIndex index) {
        if (!this.disposed && this.index == null) {
            this.index = index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private REnvHelpIndex getIndex() {
        REnvHelpIndex index;
        block18: {
            index = this.index;
            if (index != null) break block18;
            REnvHelpImpl rEnvHelpImpl = this;
            synchronized (rEnvHelpImpl) {
                if (this.disposed) {
                    throw new IllegalStateException("This help index is no longer valid.");
                }
                index = this.index;
                if (index != null) break block18;
                REnvHelpConfiguration rEnvConfig = (REnvHelpConfiguration)this.rEnv.get(REnvHelpConfiguration.class);
                if (rEnvConfig == null) {
                    throw new IllegalStateException("This R environment is no longer valid.");
                }
                try {
                    switch (rEnvConfig.getStateSharedType()) {
                        case "directory": {
                            index = new REnvIndexReader(rEnvConfig);
                            break;
                        }
                        case "server": {
                            index = ServerClientSupport.getInstance().getREnvHelpAccess(rEnvConfig);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(rEnvConfig.getStateSharedType());
                        }
                    }
                }
                catch (Exception e) {
                    RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when initializing searcher for the R help index.", (Throwable)e));
                    throw new RuntimeException("An error occurred when reading R help index.");
                }
                this.index = index;
            }
        }
        return index;
    }

    @Override
    public @Nullable RHelpPage getPage(String pkgName, String name) {
        RPkgHelp pkgHelp = this.getPackageMap().get(pkgName);
        if (pkgHelp != null) {
            return pkgHelp.getPage(name);
        }
        return null;
    }

    @Override
    public List<RHelpPage> getPagesForTopic(String topic, @Nullable ProgressMonitor m) throws StatusException {
        return this.getIndex().getPagesForTopic(topic, this.getPackageMap(), 10, m);
    }

    public @Nullable String getHtmlPage(RPkgHelp pkgHelp, String pageName, @Nullable String queryString) throws StatusException {
        return this.getIndex().getHtmlPage(pkgHelp, pageName, queryString, -1, null);
    }

    public void search(RHelpSearchQuery query, RHelpSearchRequestor requestor) throws StatusException {
        this.getIndex().search(query, (List<RPkgHelp>)this.packages, this.getPackageMap(), requestor);
    }
}

