/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class SubMenuContributionItem
extends ContributionItem
implements MenuListener {
    private MenuItem fMenuItem;
    private Menu fMenu;
    private boolean fIsMenuInitialized;

    public void dispose() {
        if (this.menuExist()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fMenuItem != null) {
            this.fMenuItem.dispose();
            this.fMenuItem = null;
        }
    }

    private boolean menuExist() {
        return this.fMenu != null && !this.fMenu.isDisposed();
    }

    public void fill(Menu parent, int index) {
        if (this.fMenuItem == null || this.fMenuItem.isDisposed()) {
            this.fMenuItem = index >= 0 ? new MenuItem(parent, 64, index) : new MenuItem(parent, 64);
            this.fMenuItem.setText(this.getLabel());
            this.fMenuItem.setImage(this.getImage());
            if (!this.menuExist()) {
                this.fMenu = new Menu(parent);
                this.fMenu.addMenuListener((MenuListener)this);
            }
            this.fMenuItem.setMenu(this.fMenu);
        }
    }

    protected abstract Image getImage();

    protected abstract String getLabel();

    protected abstract void fillMenu(Menu var1);

    public void menuShown(MenuEvent e) {
        if (!this.fIsMenuInitialized) {
            this.fIsMenuInitialized = true;
            this.fillMenu(this.fMenu);
        }
    }

    public void menuHidden(MenuEvent e) {
    }
}

