/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.wizard.WizardPage;

public class CellEditorWizardStatusUpdater
implements ICellEditorListener {
    private static final String NO_ERROR = "";
    private final CellEditor fCellEditor;
    private final WizardPage fPage;
    private String fRestore;

    public CellEditorWizardStatusUpdater(CellEditor editor, WizardPage page) {
        this.fPage = page;
        this.fCellEditor = editor;
        this.fCellEditor.addListener((ICellEditorListener)this);
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        if (this.fRestore == null) {
            this.fRestore = this.fPage.getErrorMessage();
            if (this.fRestore == null) {
                this.fRestore = NO_ERROR;
            }
        }
        if (!newValidState) {
            this.fPage.setErrorMessage(this.fCellEditor.getErrorMessage());
        } else {
            this.fPage.setErrorMessage(null);
        }
    }

    public void applyEditorValue() {
        if (this.fRestore != null) {
            this.fPage.setErrorMessage(this.fRestore != NO_ERROR ? this.fRestore : null);
            this.fRestore = null;
        }
    }

    public void cancelEditor() {
        if (this.fRestore != null) {
            this.fPage.setErrorMessage(this.fRestore != NO_ERROR ? this.fRestore : null);
            this.fRestore = null;
        }
    }
}

