/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;

public class TextViewerJFaceUpdater {
    protected final ISourceViewer fViewer;
    protected final IPreferenceStore fPreferenceStore;
    private IPropertyChangeListener fFontChangeListener;
    private final String fSymbolicFontName;

    public TextViewerJFaceUpdater(ISourceViewer viewer, IPreferenceStore preferenceStore) {
        this(viewer, preferenceStore, "org.eclipse.jface.textfont");
    }

    public TextViewerJFaceUpdater(ISourceViewer viewer, IPreferenceStore preferenceStore, String symbolicFontName) {
        assert (viewer != null);
        assert (preferenceStore != null);
        assert (symbolicFontName != null);
        this.fViewer = viewer;
        this.fPreferenceStore = preferenceStore;
        this.fSymbolicFontName = symbolicFontName;
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextViewerJFaceUpdater.this.dispose();
            }
        });
        this.fFontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (TextViewerJFaceUpdater.this.fSymbolicFontName.equals(event.getProperty())) {
                    TextViewerJFaceUpdater.this.updateFont();
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fFontChangeListener);
        this.updateFont();
    }

    protected void updateFont() {
        Font font = JFaceResources.getFont((String)this.fSymbolicFontName);
        StyledText styledText = this.fViewer.getTextWidget();
        if (UIAccess.isOkToUse((Control)styledText) && font != null) {
            this.fViewer.getTextWidget().setFont(font);
        }
    }

    public final void dispose() {
        if (this.fFontChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fFontChangeListener);
        }
        this.fFontChangeListener = null;
    }
}

