/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.eval;

import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.statet.internal.r.debug.core.eval.REvaluationResult;
import org.eclipse.statet.internal.r.debug.core.model.RDebugElement;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.r.debug.core.IRValue;

public class REvaluationExpression
extends RDebugElement
implements IErrorReportingExpression {
    private static final String[] NO_MESSAGES = new String[0];
    private final REvaluationResult result;

    public REvaluationExpression(REvaluationResult result) {
        super((RDebugTarget)result.getThread().getDebugTarget());
        this.result = result;
        this.result.getThread().getExpressionManager().register(this);
    }

    public String getExpressionText() {
        return this.result.getExpressionText();
    }

    public REvaluationResult getResult() {
        return this.result;
    }

    public boolean hasErrors() {
        return this.result.getStatus() > 4;
    }

    public String[] getErrorMessages() {
        ImList<String> messages;
        if (this.result.getStatus() >= 4 && (messages = this.result.getMessages()) != null) {
            return (String[])messages.toArray((Object[])new String[messages.size()]);
        }
        return NO_MESSAGES;
    }

    public IRValue getValue() {
        return this.result.getValue();
    }

    public void dispose() {
        this.result.getThread().getExpressionManager().unregister(this);
        this.result.free();
    }
}

