/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.ecommons.debug.core.model.IIndexedValue;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartition;
import org.eclipse.statet.ecommons.debug.core.model.VariablePartitionFactory;
import org.eclipse.statet.ecommons.models.core.util.ElementPartitionFactory;
import org.eclipse.statet.internal.r.debug.core.model.IRIndexElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RDebugElement;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.debug.core.IRDebugTarget;
import org.eclipse.statet.r.debug.core.IRValue;
import org.eclipse.statet.r.debug.core.IRVariable;

@NonNullByDefault
public abstract class RElementValue<TRElement extends CombinedRElement>
extends RDebugElement
implements IRValue {
    protected static final IRVariable[] NO_VARIABLES = new IRVariable[0];
    protected static final VariablePartitionFactory<IRIndexElementValue> PARTITION_FACTORY = new VariablePartitionFactory<IRIndexElementValue>(){

        protected IRVariable createPartition(IRIndexElementValue value, ElementPartitionFactory.PartitionHandle partition) {
            return new RVariablePartition(value, partition);
        }
    };
    protected final TRElement element;
    protected final int stamp;

    public RElementValue(RDebugTarget debugTarget, TRElement element, int stamp) {
        super(debugTarget);
        this.element = element;
        this.stamp = stamp;
    }

    public final TRElement getElement() {
        return this.element;
    }

    @Override
    public String getValueString() throws DebugException {
        switch (this.element.getRObjectType()) {
            case 1: {
                return "NULL";
            }
        }
        return "";
    }

    public String getReferenceTypeName() throws DebugException {
        return this.element.getRClassName();
    }

    @Override
    public String getDetailString() {
        switch (this.element.getRObjectType()) {
            case 1: {
                return "NULL";
            }
        }
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    public @NonNull IVariable[] getVariables() throws DebugException {
        return NO_VARIABLES;
    }

    protected static class RVariablePartition
    extends VariablePartition<IRIndexElementValue>
    implements IRVariable,
    IRValue {
        public RVariablePartition(IRIndexElementValue value, ElementPartitionFactory.PartitionHandle partition) {
            super((IIndexedValue)value, partition);
        }

        @Override
        public IRDebugTarget getDebugTarget() {
            return (IRDebugTarget)super.getDebugTarget();
        }

        @Override
        public @Nullable IRVariable getParent() {
            return null;
        }

        protected int getNameIndexBase() {
            return 1;
        }

        @Override
        public IRValue getValue() {
            return this;
        }

        @Override
        public IRVariable getAssignedVariable() {
            return this;
        }

        @Override
        public String getDetailString() {
            return "";
        }
    }
}

