/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.ArgsDefinition;
import org.eclipse.statet.r.core.model.RLangMethod;

@NonNullByDefault
public class RFunctionValue
extends RElementVariableValue<CombinedRElement> {
    public RFunctionValue(RElementVariable variable) {
        super(variable);
    }

    @Override
    public String getValueString() throws DebugException {
        if (this.element instanceof RLangMethod) {
            RLangMethod lang = (RLangMethod)this.element;
            StringBuilder sb = new StringBuilder();
            ArgsDefinition args = lang.getArgsDefinition();
            sb.append("function(");
            if (args == null) {
                sb.append("<unknown>");
            } else if (args.size() > 0) {
                ArgsDefinition.Arg arg = args.get(0);
                if (arg.name != null) {
                    sb.append(arg.name);
                }
                int i = 1;
                while (i < args.size()) {
                    sb.append(", ");
                    ArgsDefinition.Arg arg2 = args.get(i);
                    if (arg2.name != null) {
                        sb.append(arg2.name);
                    }
                    ++i;
                }
            }
            sb.append(")");
            return sb.toString();
        }
        return super.getValueString();
    }
}

