/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.sourcelookup;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainerTypeDelegate;
import org.eclipse.statet.internal.r.debug.core.sourcelookup.Messages;
import org.eclipse.statet.r.debug.core.sourcelookup.RProjectSourceContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RProjectSourceContainerTypeDelegate
extends AbstractSourceContainerTypeDelegate {
    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        Element node = this.parseDocument(memento);
        if (node.getNodeType() == 1) {
            Element element = node;
            if ("org.eclipse.statet.r.debugSourceContainers.RProjectType".equals(element.getNodeName())) {
                String s = element.getAttribute("name");
                if (s == null || s.isEmpty()) {
                    this.abort(Messages.RProjectSourceContainer_error_InvalidConfiguration_message, null);
                }
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(s);
                return new RProjectSourceContainer(project, false);
            }
            this.abort(Messages.RProjectSourceContainer_error_InvalidConfiguration_message, null);
        }
        this.abort(Messages.RProjectSourceContainer_error_InvalidConfiguration_message, null);
        return null;
    }

    public String getMemento(ISourceContainer container) throws CoreException {
        RProjectSourceContainer rProjectContainer = (RProjectSourceContainer)container;
        Document document = this.newDocument();
        Element element = document.createElement("org.eclipse.statet.r.debugSourceContainers.RProjectType");
        element.setAttribute("name", rProjectContainer.getProject().getName());
        document.appendChild(element);
        return this.serializeDocument(document);
    }
}

