/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.server.renv;

import java.nio.file.Path;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.server.Application;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="renvs")
@NonNullByDefault
public class REnvManagerConfiguration {
    private @Nullable Path rootDir;

    public void setPath(@Nullable String path) {
        this.rootDir = path != null ? Path.of(path, new String[0]) : null;
    }

    public Path getRootDirectory() {
        Path dir = this.rootDir;
        if (dir != null) {
            return dir;
        }
        ApplicationHome applicationHome = new ApplicationHome(Application.class);
        dir = applicationHome.getDir().toPath();
        return dir.resolve("renvs");
    }
}

