/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.UIElement;

@NonNullByDefault
public abstract class AbstractScopeHandler
extends AbstractHandler {
    private Object scope;
    private @Nullable String commandId;
    private @Nullable Map<String, Object> filter;

    public AbstractScopeHandler(Object scope, @Nullable String commandId) {
        this.init(scope, commandId);
    }

    public AbstractScopeHandler() {
    }

    protected void init(Object scope, @Nullable String commandId) {
        if (ObjectUtils.isNonNull((Object)this.scope)) {
            throw new IllegalStateException();
        }
        this.scope = scope;
        this.commandId = commandId;
        if (this.scope instanceof IWorkbenchWindow) {
            this.filter = Collections.singletonMap("org.eclipse.ui.IWorkbenchWindow", this.scope);
        }
    }

    public Object getScope() {
        return this.scope;
    }

    public @Nullable String getCommandId() {
        return this.commandId;
    }

    public final void setEnabled(@Nullable Object appContext) {
        if (appContext instanceof IEvaluationContext) {
            this.setEnabled((IEvaluationContext)appContext);
        }
    }

    public void setEnabled(IEvaluationContext context) {
    }

    protected void refreshElements() {
        String commandId = this.commandId;
        if (commandId != null) {
            WorkbenchUIUtils.refreshCommandElements(commandId, (IHandler2)this, this.filter);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    public final @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        Object appContext = event.getApplicationContext();
        if (appContext instanceof IEvaluationContext) {
            return this.execute(event, (IEvaluationContext)appContext);
        }
        return null;
    }

    public abstract @Nullable Object execute(ExecutionEvent var1, IEvaluationContext var2) throws ExecutionException;
}

