/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public abstract class WorkbenchScopingHandler
extends AbstractHandler
implements IExecutableExtension,
IWindowListener,
IHandlerListener,
IElementUpdater {
    private @Nullable String commandId;
    private Map<Object, AbstractScopeHandler> scopeHandlers = new IdentityHashMap<Object, AbstractScopeHandler>();
    private @Nullable AbstractScopeHandler activeHandler;

    public WorkbenchScopingHandler() {
        this.init();
    }

    public WorkbenchScopingHandler(String commandId) {
        this.init();
        this.commandId = commandId;
    }

    private void init() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, @Nullable Object data) throws CoreException {
        String s = config.getAttribute("commandId");
        if (s != null) {
            this.commandId = s.intern();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<Object, AbstractScopeHandler> handlers;
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.removeWindowListener((IWindowListener)this);
        Map<Object, AbstractScopeHandler> map = this.scopeHandlers;
        synchronized (map) {
            handlers = this.scopeHandlers;
            this.scopeHandlers = Collections.emptyMap();
        }
        for (Map.Entry<Object, AbstractScopeHandler> entry : handlers.entrySet()) {
            this.disposeScope(entry.getKey(), entry.getValue());
        }
        super.dispose();
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.removeScope(window);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    protected @Nullable String getCommandId() {
        return this.commandId;
    }

    protected @Nullable AbstractScopeHandler getActiveHandler() {
        return this.activeHandler;
    }

    protected @Nullable Object getScope(@Nullable IServiceLocator serviceLocator) {
        if (serviceLocator != null) {
            return serviceLocator.getService(IWorkbenchWindow.class);
        }
        return null;
    }

    protected @Nullable Object getScope(IEvaluationContext context) {
        Object o = context.getVariable(IWorkbenchWindow.class.getName());
        if (o == null || o == IEvaluationContext.UNDEFINED_VARIABLE) {
            o = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if (o instanceof IWorkbenchWindow) {
            return o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable AbstractScopeHandler getScopeHandler(@Nullable Object scope) {
        AbstractScopeHandler handler = null;
        if (scope != null) {
            Map<Object, AbstractScopeHandler> map = this.scopeHandlers;
            synchronized (map) {
                handler = this.scopeHandlers.get(scope);
                if (handler == null) {
                    handler = this.createScopeHandler(scope);
                    handler.addHandlerListener(this);
                    this.scopeHandlers.put(scope, handler);
                }
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeScope(Object scope) {
        AbstractScopeHandler handler;
        Map<Object, AbstractScopeHandler> map = this.scopeHandlers;
        synchronized (map) {
            handler = this.scopeHandlers.remove(scope);
        }
        if (handler != null) {
            handler.dispose();
        }
    }

    protected abstract AbstractScopeHandler createScopeHandler(Object var1);

    protected void disposeScope(Object scope, AbstractScopeHandler handler) {
        handler.dispose();
    }

    public synchronized void setEnabled(@Nullable Object appContext) {
        if (appContext instanceof IEvaluationContext) {
            AbstractScopeHandler handler;
            IEvaluationContext evalContext = (IEvaluationContext)appContext;
            this.activeHandler = handler = this.getScopeHandler(this.getScope(evalContext));
            if (handler != null) {
                handler.setEnabled(evalContext);
                this.setBaseEnabled(handler.isEnabled());
                return;
            }
        }
        this.setBaseEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handlerChanged(HandlerEvent handlerEvent) {
        AbstractScopeHandler handler = (AbstractScopeHandler)handlerEvent.getHandler();
        WorkbenchScopingHandler workbenchScopingHandler = this;
        synchronized (workbenchScopingHandler) {
            if (handler == this.activeHandler) {
                this.setBaseEnabled(handler.isEnabled());
                return;
            }
        }
        handler.refreshElements();
    }

    public void updateElement(UIElement element, Map parameters) {
        AbstractScopeHandler handler = this.getScopeHandler(this.getScope(element.getServiceLocator()));
        if (handler != null) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, element);
            try {
                handler.updateElement(element, parameters);
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        IEvaluationContext evalContext;
        AbstractScopeHandler handler;
        Object appContext = event.getApplicationContext();
        if (!(appContext instanceof IEvaluationContext) || (handler = this.getScopeHandler(this.getScope(evalContext = (IEvaluationContext)appContext))) == null) return null;
        WorkbenchScopingHandler workbenchScopingHandler = this;
        synchronized (workbenchScopingHandler) {
            block4: {
                handler.setEnabled(evalContext);
                if (handler.isEnabled()) break block4;
                return null;
            }
            return handler.execute(event, evalContext);
        }
    }
}

