/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.util;

import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public final class ArrayUtils {
    public static int indexOf(byte[] a, byte[] b) {
        ObjectUtils.nonNullAssert(a);
        int l = b.length;
        if (a == b || l == 0) {
            return 0;
        }
        if (a.length < l) {
            return -1;
        }
        byte b0 = b[0];
        if (l == 1) {
            return ArrayUtils.indexOf(a, b0);
        }
        int lastStart = a.length - l;
        int start = 0;
        while (start <= lastStart) {
            block7: {
                if (a[start] == b0 && a[start + 1] == b[1]) {
                    int i = start + 2;
                    int j = 2;
                    while (j < l) {
                        if (a[i] == b[j]) {
                            ++i;
                            ++j;
                            continue;
                        }
                        break block7;
                    }
                    return start;
                }
            }
            ++start;
        }
        return -1;
    }

    public static int indexOf(byte[] a, byte b) {
        int i = 0;
        while (i < a.length) {
            if (a[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(byte[] a, byte[] b) {
        return ArrayUtils.indexOf(a, b) != -1;
    }

    public static boolean contains(byte[] a, byte b) {
        int i = 0;
        while (i < a.length) {
            if (a[i] == b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean startsWith(byte[] a, byte[] b) {
        ObjectUtils.nonNullAssert(a);
        int l = b.length;
        if (a == b || l == 0) {
            return true;
        }
        if (a.length < l) {
            return false;
        }
        if (l < 16) {
            int i = 0;
            while (i < l) {
                if (a[i] != b[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return Arrays.equals(a, 0, l, b, 0, l);
    }

    public static boolean startsWith(byte[] a, byte b) {
        return a.length > 0 && a[0] == b;
    }

    public static byte[] concat(byte[] a1, byte[] a2) {
        int n1 = a1.length;
        byte[] a = new byte[n1 + a2.length];
        System.arraycopy(a1, 0, a, 0, n1);
        System.arraycopy(a2, 0, a, n1, a2.length);
        return a;
    }

    public static int indexOf(int[] a, int[] b) {
        ObjectUtils.nonNullAssert(a);
        int l = b.length;
        if (a == b || l == 0) {
            return 0;
        }
        if (a.length < l) {
            return -1;
        }
        int b0 = b[0];
        if (l == 1) {
            return ArrayUtils.indexOf(a, b0);
        }
        int lastStart = a.length - l;
        int start = 0;
        while (start <= lastStart) {
            block7: {
                if (a[start] == b0 && a[start + 1] == b[1]) {
                    int i = start + 2;
                    int j = 2;
                    while (j < l) {
                        if (a[i] == b[j]) {
                            ++i;
                            ++j;
                            continue;
                        }
                        break block7;
                    }
                    return start;
                }
            }
            ++start;
        }
        return -1;
    }

    public static int indexOf(int[] a, int b) {
        int i = 0;
        while (i < a.length) {
            if (a[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(int[] a, int[] b) {
        return ArrayUtils.indexOf(a, b) != -1;
    }

    public static boolean contains(int[] a, int b) {
        int i = 0;
        while (i < a.length) {
            if (a[i] == b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean startsWith(int[] a, int[] b) {
        ObjectUtils.nonNullAssert(a);
        int l = b.length;
        if (a == b || l == 0) {
            return true;
        }
        if (a.length < l) {
            return false;
        }
        if (l < 16) {
            int i = 0;
            while (i < l) {
                if (a[i] != b[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return Arrays.equals(a, 0, l, b, 0, l);
    }

    public static boolean startsWith(int[] a, int b) {
        return a.length > 0 && a[0] == b;
    }

    public static int[] concat(int[] a1, int[] a2) {
        int n1 = a1.length;
        int[] a = new int[n1 + a2.length];
        System.arraycopy(a1, 0, a, 0, n1);
        System.arraycopy(a2, 0, a, n1, a2.length);
        return a;
    }

    private ArrayUtils() {
    }
}

