/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchConfigurationTab2;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.statet.ecommons.debug.ui.config.WrappedLaunchConfigurationTab;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

@NonNullByDefault
class ExtJavaStandardVMCommonTab
extends WrappedLaunchConfigurationTab {
    static final Pattern STANDARD_VM_TAB_CLASS_PATTERN = Pattern.compile("\\Qorg.eclipse.jdt.\\E.*\\Q.StandardVMCommandTab\\E");
    private static final String JAVA_COMMAND_MARKER = "XXX-SPECIFIED-JAVA-COMMAND-XXX";
    private @Nullable Text javaCommandText;

    public ExtJavaStandardVMCommonTab(ILaunchConfigurationTab2 vmTab) {
        super(vmTab);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Control control = this.getControl();
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Button) {
                    Button label = (Button)child;
                    String text = label.getText();
                    if (text.contains("(javaw)")) {
                        label.setText(text.replace("(javaw)", "(javaw / javaw-utf8)"));
                    }
                } else if (child instanceof Text) {
                    this.javaCommandText = (Text)child;
                    break;
                }
                ++n2;
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block6: {
            try {
                Text javaCommandText;
                String javaCommand;
                Map vmSpecificAttributes = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
                if (vmSpecificAttributes == null || (javaCommand = (String)vmSpecificAttributes.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND)) == null || javaCommand.isEmpty() || (javaCommandText = this.javaCommandText) == null) break block6;
                vmSpecificAttributes.put(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, JAVA_COMMAND_MARKER);
                try {
                    super.initializeFrom(configuration);
                    if (javaCommandText.getText().equals(JAVA_COMMAND_MARKER)) {
                        javaCommandText.setText(javaCommand);
                        return;
                    }
                }
                finally {
                    vmSpecificAttributes.put(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, javaCommand);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.initializeFrom(configuration);
    }
}

