/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing.actions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingManager;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingUI;
import org.eclipse.statet.docmlet.base.ui.sourceediting.DocEditor;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.ecommons.debug.ui.config.actions.ActionUtil;
import org.eclipse.statet.ecommons.debug.ui.config.actions.RunActiveConfigScopeHandler;
import org.eclipse.statet.ecommons.ui.actions.WorkbenchScopingHandler;
import org.eclipse.statet.internal.docmlet.base.ui.processing.DocActionUtil;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;

@NonNullByDefault
public class RunActiveDocConfigWorkbenchHandler
extends WorkbenchScopingHandler
implements IExecutableExtension,
IElementUpdater {
    private ImIdentitySet<String> launchFlags;

    public void setInitializationData(IConfigurationElement config, String propertyName, @Nullable Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        try {
            String commandId;
            Map parameters = data instanceof Map ? (Map)data : Collections.emptyMap();
            ImIdentitySet<String> launchFlags = null;
            String s = (String)parameters.get("launchFlags");
            if (s != null) {
                launchFlags = CollectionUtils.toIdentifierSet((String[])s.split(";"));
            }
            if (launchFlags == null) {
                launchFlags = (ImIdentitySet)ObjectUtils.nullable(this.launchFlags);
            }
            if (launchFlags == null && (commandId = this.getCommandId()) != null) {
                launchFlags = this.getCommandLaunchFlags(commandId);
            }
            if (launchFlags == null) {
                throw new IllegalArgumentException("launchFlags= <missing>");
            }
            this.launchFlags = launchFlags;
        }
        catch (IllegalArgumentException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)"Invalid declaration of contribution by ''{0}''.", (Object)config.getContributor().getName()), (Throwable)e));
        }
    }

    protected ImIdentitySet<String> getLaunchFlags() {
        return this.launchFlags;
    }

    protected ImIdentitySet<String> getCommandLaunchFlags(String commandId) {
        switch (commandId) {
            case "org.eclipse.statet.docmlet.commands.ProcessAndPreviewDefault": {
                return DocProcessingUI.CommonFlags.PROCESS_AND_PREVIEW;
            }
            case "org.eclipse.statet.docmlet.commands.ProcessDocDefault": {
                return DocProcessingUI.CommonFlags.PROCESS;
            }
            case "org.eclipse.statet.docmlet.commands.PreviewDocDefault": {
                return DocProcessingUI.CommonFlags.OPEN_OUTPUT;
            }
        }
        throw new IllegalArgumentException("commandId= " + commandId);
    }

    protected ScopeHandler createScopeHandler(Object scope) {
        return new ScopeHandler((IWorkbenchWindow)scope, this.getCommandId(), this.getLaunchFlags());
    }

    private static class ScopeHandler
    extends RunActiveConfigScopeHandler<IFile>
    implements LaunchConfigManager.Listener {
        private @Nullable String lastTypeId;

        public ScopeHandler(IWorkbenchWindow scope, @Nullable String commandId, ImIdentitySet<String> launchFlags) {
            super(scope, commandId, (ActionUtil)new DocActionUtil(1), launchFlags);
        }

        private @Nullable IContentType getType() {
            IWorkbenchWindow window = this.getWorkbenchWindow();
            IEditorPart editor = window.getActivePage().getActiveEditor();
            if (editor instanceof DocEditor) {
                return ((DocEditor)editor).getContentType();
            }
            return null;
        }

        protected synchronized byte updateManager(IEvaluationContext context) {
            DocProcessingManager manager;
            IContentType type = this.getType();
            if (type != null) {
                if (type.getId() == this.lastTypeId) {
                    return 0;
                }
                this.lastTypeId = type.getId();
                manager = DocProcessingUI.getDocProcessingManager(type, true);
            } else {
                this.lastTypeId = null;
                manager = null;
            }
            return this.updateManager(manager);
        }
    }
}

