/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort.core;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.sort.core.ClearSortCommand;
import org.eclipse.statet.ecommons.waltable.sort.core.SortColumnEvent;
import org.eclipse.statet.ecommons.waltable.sort.core.SortModel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class ClearSortCommandHandler
implements LayerCommandHandler<ClearSortCommand> {
    private final SortModel sortModel;

    public ClearSortCommandHandler(SortModel sortModel) {
        this.sortModel = sortModel;
    }

    @Override
    public Class<ClearSortCommand> getCommandClass() {
        return ClearSortCommand.class;
    }

    @Override
    public boolean doCommand(Layer targetLayer, ClearSortCommand command) {
        LayerDim layerDim = targetLayer.getDim(Orientation.HORIZONTAL);
        List<Long> sortedIds = this.sortModel.getSortedColumnIds();
        LRangeList sortedPositions = new LRangeList();
        for (Long id : sortedIds) {
            long position = layerDim.getPositionById(id);
            if (position == Long.MIN_VALUE) continue;
            sortedPositions.values().add(position);
        }
        this.sortModel.clear();
        SortColumnEvent sortEvent = new SortColumnEvent(layerDim, sortedPositions);
        layerDim.getLayer().fireLayerEvent(sortEvent);
        return true;
    }
}

