/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport.swt;

import org.eclipse.statet.ecommons.waltable.core.swt.SwtUtils;
import org.eclipse.statet.ecommons.waltable.edit.EditUtils;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayerDim;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

@NonNullByDefault
public class ScrollBarHandler
implements Listener {
    private final ViewportLayerDim dim;
    private final ScrollBar scrollBar;
    private double factor = 1.0;
    private boolean dragging = false;

    public static @Nullable ScrollBarHandler create(ViewportLayerDim layerDim, Object control) {
        ScrollBar scrollBar;
        if (control instanceof Scrollable && (scrollBar = SwtUtils.getScrollBar((Scrollable)control, layerDim.getOrientation())) != null) {
            return new ScrollBarHandler(layerDim, scrollBar);
        }
        return null;
    }

    public ScrollBarHandler(ViewportLayerDim dim, ScrollBar scrollBar) {
        this.dim = dim;
        this.scrollBar = scrollBar;
        this.scrollBar.addListener(13, (Listener)this);
        scrollBar.getParent().addListener(SwtUtils.getMouseWheelEventType(this.dim.getOrientation()), (Listener)this);
    }

    public void dispose() {
        if (this.scrollBar != null && !this.scrollBar.isDisposed()) {
            this.scrollBar.removeListener(13, (Listener)this);
            this.scrollBar.removeListener(SwtUtils.getMouseWheelEventType(this.dim.getOrientation()), (Listener)this);
        }
    }

    public void handleEvent(Event event) {
        boolean handle = true;
        if (!this.dragging && !EditUtils.commitAndCloseActiveEditor()) {
            handle = false;
        }
        boolean bl = this.dragging = event.detail == 1;
        if (!handle || !event.doit) {
            this.adjustScrollBar();
            return;
        }
        switch (event.type) {
            case 37: 
            case 38: {
                if (event.count > 0) {
                    while (event.count > 0) {
                        this.dim.scrollBackwardByStep();
                        --event.count;
                    }
                } else if (event.count < 0) {
                    while (event.count < 0) {
                        this.dim.scrollForwardByStep();
                        ++event.count;
                    }
                }
                event.doit = false;
                return;
            }
            case 13: {
                switch (event.detail) {
                    case 0x1000007: {
                        this.dim.scrollBackwardToBound();
                        return;
                    }
                    case 0x1000008: {
                        this.dim.scrollForwardToBound();
                        return;
                    }
                    case 0x1000005: {
                        this.dim.scrollBackwardByPage();
                        return;
                    }
                    case 0x1000006: {
                        this.dim.scrollForwardByPage();
                        return;
                    }
                    case 0x1000001: 
                    case 0x1000003: {
                        this.dim.scrollBackwardByStep();
                        return;
                    }
                    case 0x1000002: 
                    case 0x1000004: {
                        this.dim.scrollForwardByStep();
                        return;
                    }
                }
                this.dim.setOriginPixel(this.dim.getMinimumOriginPixel() + (long)((double)this.scrollBar.getSelection() / this.factor));
                return;
            }
        }
    }

    public ScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public void adjustScrollBar() {
        if (this.scrollBar.isDisposed()) {
            return;
        }
        long startPixel = this.dim.getOriginPixel() - this.dim.getMinimumOriginPixel();
        this.scrollBar.setSelection((int)(this.factor * (double)startPixel));
    }

    public void recalculateScrollBarSize() {
        int max;
        int viewportWindowSpan;
        if (this.scrollBar.isDisposed()) {
            return;
        }
        long scrollablePixel = this.dim.getScrollable().getSize() - this.dim.getMinimumOriginPixel();
        long viewportWindowPixel = this.dim.getSize();
        if (scrollablePixel <= 0x3FFFFFFFL) {
            this.factor = 1.0;
            viewportWindowSpan = (int)viewportWindowPixel;
            max = (int)scrollablePixel;
        } else {
            this.factor = 1.073741823E9 / (double)scrollablePixel;
            double exactSpan = this.factor * (double)viewportWindowPixel;
            viewportWindowSpan = (int)Math.ceil(exactSpan);
            max = (int)Math.min(0x3FFFFFFFL + (long)(((double)viewportWindowSpan - exactSpan) / this.factor), Integer.MAX_VALUE);
        }
        if (this.scrollBar.isDisposed()) {
            return;
        }
        this.scrollBar.setMaximum(max);
        this.scrollBar.setPageIncrement(Math.max(viewportWindowSpan / 4, 1));
        if (viewportWindowSpan < max && viewportWindowPixel != 0L) {
            this.scrollBar.setThumb(viewportWindowSpan);
            this.scrollBar.setEnabled(true);
            this.scrollBar.setVisible(true);
        } else {
            this.scrollBar.setThumb(max);
            this.scrollBar.setEnabled(false);
            this.scrollBar.setVisible(false);
        }
        this.adjustScrollBar();
    }
}

