/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.r;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.ecommons.text.core.input.DocumentParserInput;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.internal.r.ui.RIdentifierGroups;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.r.core.source.RLexer;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.ui.text.r.IRTextTokens;

@NonNullByDefault
public class RDefaultTextStyleScanner
extends DocumentParserInput
implements ITokenScanner,
ISettingsChangedHandler {
    private final RLexer lexer = this.createLexer();
    private @Nullable RTerminal lexerToken;
    private final EnumMap<RTerminal, IToken> tokens;
    private final IToken defaultToken;
    private final Map<String, IToken> specialSymbols;
    private final TextStyleManager<?> textStyles;
    private int currentOffset;
    private int currentLength;

    public RDefaultTextStyleScanner(TextStyleManager<?> textStyles) {
        this.lexer.reset((TextParserInput)this);
        this.textStyles = textStyles;
        this.defaultToken = this.getToken("text_R_rDefault");
        this.tokens = new EnumMap(RTerminal.class);
        this.registerTokens(this.tokens);
        this.specialSymbols = new HashMap<String, IToken>();
        this.updateSymbols(this.specialSymbols);
    }

    protected RLexer createLexer() {
        return new RLexer(32787);
    }

    protected void checkTokenMap() {
        RTerminal[] all;
        RTerminal[] rTerminalArray = all = RTerminal.values();
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            RTerminal t = rTerminalArray[n2];
            if (this.tokens.get(t) == null) {
                System.out.println("Style Missing for: " + t.name());
            }
            ++n2;
        }
    }

    protected final RLexer getLexer() {
        return this.lexer;
    }

    protected final TextStyleManager<?> getTextStyles() {
        return this.textStyles;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.reset(document);
        this.init(offset, offset + length);
        this.lexer.reset((TextParserInput)this);
        this.currentOffset = offset;
        this.currentLength = 0;
    }

    protected void resetSpecialSymbols() {
        this.specialSymbols.clear();
        this.updateSymbols(this.specialSymbols);
    }

    public IToken nextToken() {
        this.currentOffset += this.currentLength;
        if (this.lexerToken == null) {
            this.lexerToken = this.lexer.next();
        }
        this.currentLength = this.lexer.getOffset() - this.currentOffset;
        if (this.currentLength != 0) {
            return this.defaultToken;
        }
        this.currentLength = this.lexer.getLength();
        return this.getTokenFromScannerToken();
    }

    protected IToken getTokenFromScannerToken() {
        if (this.lexerToken == RTerminal.SYMBOL) {
            IToken token;
            String text = this.lexer.getText();
            if (text != null && (token = this.specialSymbols.get(text)) != null) {
                this.lexerToken = null;
                return token;
            }
            this.lexerToken = null;
            return this.defaultToken;
        }
        @Nullable IToken token = this.tokens.get(this.lexerToken);
        this.lexerToken = null;
        return token;
    }

    public int getTokenOffset() {
        return this.currentOffset;
    }

    public int getTokenLength() {
        return this.currentLength;
    }

    protected IToken getToken(String key) {
        return this.textStyles.getToken(key);
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        if (groupIds.contains("r.editor/identifiergroups")) {
            this.resetSpecialSymbols();
            options.put("affects.Presentation", Boolean.TRUE);
        }
    }

    protected void registerTokens(EnumMap<RTerminal, IToken> map) {
        map.put(RTerminal.EOF, Token.EOF);
        CollectionUtils.putAll(map, IRTextTokens.FLOWCONTROL, (Object)this.getToken("text_R_rFlowcontrol"));
        CollectionUtils.putAll(map, IRTextTokens.GROUPING, (Object)this.getToken("text_R_rGrouping"));
        CollectionUtils.putAll(map, IRTextTokens.SEPARATOR, (Object)this.getToken("text_R_rSeparators"));
        CollectionUtils.putAll(map, IRTextTokens.ASSIGN, (Object)this.getToken("text_R_rAssignment"));
        CollectionUtils.putAll(map, IRTextTokens.ASSIGN_SUB_EQUAL, (Object)this.getToken("text_R_rAssignment.Equalsign"));
        CollectionUtils.putAll(map, IRTextTokens.ASSIGN_SUB_PIPE, (Object)this.getToken("text_R_rAssignment.Pipe"));
        CollectionUtils.putAll(map, IRTextTokens.OP, (Object)this.getToken("text_R_rOtherOperators"));
        CollectionUtils.putAll(map, IRTextTokens.OP_SUB_LOGICAL, (Object)this.getToken("text_R_rOtherOperators.Logical"));
        CollectionUtils.putAll(map, IRTextTokens.OP_SUB_RELATIONAL, (Object)this.getToken("text_R_rOtherOperators.Relational"));
        CollectionUtils.putAll(map, IRTextTokens.SUBACCESS, (Object)this.getToken("text_R_rIndexing"));
        CollectionUtils.putAll(map, IRTextTokens.NSGET, (Object)this.getToken("text_R_rIndexing"));
        CollectionUtils.putAll(map, IRTextTokens.SPECIALCONST, (Object)this.getToken("text_R_rSpecialConstants"));
        CollectionUtils.putAll(map, IRTextTokens.LOGICALCONST, (Object)this.getToken("text_R_rLogicalConstants"));
        CollectionUtils.putAll(map, IRTextTokens.SYMBOL, (Object)this.getToken("text_R_rDefault"));
        CollectionUtils.putAll(map, IRTextTokens.NUM, (Object)this.getToken("text_R_rNumbers"));
        CollectionUtils.putAll(map, IRTextTokens.NUM_SUB_INT, (Object)this.getToken("text_R_rNumbers.Integer"));
        CollectionUtils.putAll(map, IRTextTokens.NUM_SUB_CPLX, (Object)this.getToken("text_R_rNumbers.Complex"));
        CollectionUtils.putAll(map, IRTextTokens.UNDEFINED, (Object)this.getToken("text_R_rUndefined"));
        CollectionUtils.putAll(map, IRTextTokens.STRING, (Object)this.getToken("text_R_rString"));
        map.put(RTerminal.SYMBOL_G, this.getToken("text_R_rString"));
        map.put(RTerminal.SPECIAL, this.getToken("text_R_rOtherOperators"));
        CollectionUtils.putAll(map, IRTextTokens.COMMENT, (Object)this.getToken("text_R_rComment"));
    }

    protected void updateSymbols(Map<String, IToken> map) {
        RIdentifierGroups groups = RUIPlugin.getInstance().getRIdentifierGroups();
        groups.getReadLock().lock();
        try {
            CollectionUtils.putAll(map, groups.getAssignmentIdentifiers(), (Object)this.getToken("text_R_rDefault.Assignment"));
            CollectionUtils.putAll(map, groups.getLogicalIdentifiers(), (Object)this.getToken("text_R_rDefault.Logical"));
            CollectionUtils.putAll(map, groups.getFlowcontrolIdentifiers(), (Object)this.getToken("text_R_rDefault.Flowcontrol"));
            CollectionUtils.putAll(map, groups.getCustom1Identifiers(), (Object)this.getToken("text_R_rDefault.Custom2"));
            CollectionUtils.putAll(map, groups.getCustom2Identifiers(), (Object)this.getToken("text_R_rDefault.Custom1"));
        }
        finally {
            groups.getReadLock().unlock();
        }
    }
}

