/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.core.model;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstInfo;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceElement;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitEmbeddedModelReconciler;
import org.eclipse.statet.docmlet.wikitext.core.model.build.WikidocSourceUnitModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.project.WikitextProject;
import org.eclipse.statet.internal.redocs.wikitext.r.core.model.WikidocRChunkReconciler;
import org.eclipse.statet.internal.redocs.wikitext.r.core.model.WikidocRweaveSuModelContainer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.model.core.build.EmbeddingForeignReconcileTask;
import org.eclipse.statet.ltk.model.core.build.SourceUnitModelContainer;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.project.core.LtkProject;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.project.RProjects;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.redocs.r.core.model.RChunkReconcileConfig;
import org.eclipse.statet.redocs.wikitext.r.core.source.RweaveMarkupLanguage;

@NonNullByDefault
public class WikidocREmbeddedModelReconciler
implements WikidocSourceUnitEmbeddedModelReconciler<RChunkReconcileConfig> {
    public String getModelTypeId() {
        return "R";
    }

    private @Nullable WikidocRChunkReconciler getReconciler(WikitextMarkupLanguage markupLanguage) {
        if (markupLanguage instanceof RweaveMarkupLanguage) {
            return WikidocRChunkReconciler.getInstance((RweaveMarkupLanguage)markupLanguage);
        }
        return null;
    }

    private @Nullable WikidocRChunkReconciler getReconciler(WikitextAstInfo astInfo) {
        return this.getReconciler(astInfo.getMarkupLanguage());
    }

    public RChunkReconcileConfig createConfig(@Nullable IProject wsProject, @Nullable WikitextProject wikitextProject, int level) {
        RProject rProject = RProjects.getRProject((IProject)wsProject);
        RProject rCoreAccess = rProject != null ? rProject : RCore.getWorkbenchAccess();
        return new RChunkReconcileConfig((RCoreAccess)rCoreAccess, (LtkProject)wikitextProject);
    }

    public void reconcileAst(SourceContent content, List<Embedded> list, WikitextMarkupLanguage markupLanguage, WikidocSourceUnitModelContainer<?> container, RChunkReconcileConfig config, int level) {
        WikidocRChunkReconciler reconciler;
        if (container instanceof WikidocRweaveSuModelContainer && (reconciler = this.getReconciler(markupLanguage)) != null) {
            reconciler.reconcileAst((SourceUnitModelContainer)((WikidocRweaveSuModelContainer)container), content, list, (RSourceConfig)config.getSourceConfig());
        }
    }

    public void reconcileModel(WikidocSourceUnitModelInfo wikitextModel, SourceContent content, List<? extends EmbeddingForeignReconcileTask<Embedded, WikitextSourceElement>> list, WikidocSourceUnitModelContainer<?> container, RChunkReconcileConfig config, int level, SubMonitor m) {
        WikidocRChunkReconciler reconciler;
        if (container instanceof WikidocRweaveSuModelContainer && (reconciler = this.getReconciler(wikitextModel.getAst())) != null) {
            reconciler.reconcileModel((SourceUnitModelContainer)((WikidocRweaveSuModelContainer)container), content, (SourceUnitModelInfo)wikitextModel, list, level, (IProgressMonitor)m);
        }
    }

    public void reportIssues(WikidocSourceUnitModelInfo wikitextModel, SourceContent content, IssueRequestor issueRequestor, WikidocSourceUnitModelContainer<?> container, RChunkReconcileConfig config, int level) {
        WikidocRChunkReconciler reconciler;
        if (container instanceof WikidocRweaveSuModelContainer && (reconciler = this.getReconciler(wikitextModel.getAst())) != null) {
            reconciler.reportEmbeddedIssues((SourceUnitModelContainer)((WikidocRweaveSuModelContainer)container), content, (SourceUnitModelInfo)wikitextModel, issueRequestor, config, level);
        }
    }
}

