/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.util;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class RCodeBuilder {
    private final StringBuilder sb;

    public static void appendStringD(StringBuilder sb, CharSequence s) {
        sb.ensureCapacity(sb.length() + 2);
        int idxDone = 0;
        sb.append('\"');
        int idx = 0;
        while (idx < s.length()) {
            char c = s.charAt(idx);
            switch (c) {
                case '\\': {
                    if (idxDone < idx) {
                        sb.append(s, idxDone, idx);
                    }
                    sb.append("\\\\");
                    idxDone = idx + 1;
                    break;
                }
                case '\"': {
                    if (idxDone < idx) {
                        sb.append(s, idxDone, idx);
                    }
                    sb.append("\\\"");
                    idxDone = idx + 1;
                    break;
                }
            }
            ++idx;
        }
        if (idxDone < s.length()) {
            sb.append(s, idxDone, s.length());
        }
        sb.append('\"');
    }

    public RCodeBuilder() {
        this.sb = new StringBuilder();
    }

    public RCodeBuilder(int initialCapacity) {
        this.sb = new StringBuilder(initialCapacity);
    }

    public RCodeBuilder clear() {
        this.sb.setLength(0);
        return this;
    }

    public RCodeBuilder append(CharSequence code) {
        this.sb.append(code);
        return this;
    }

    public RCodeBuilder append(String code) {
        this.sb.append(code);
        return this;
    }

    public RCodeBuilder append(CharSequence code, int startIndex, int endIndex) {
        this.sb.append(code, startIndex, endIndex);
        return this;
    }

    public RCodeBuilder appendChar(CharSequence s) {
        RCodeBuilder.appendStringD(this.sb, s);
        return this;
    }

    public String build() {
        return this.sb.toString();
    }

    public String toString() {
        return this.sb.toString();
    }
}

