/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.menu.bitmap;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.export.core.AbstractSeriesExportHandler;
import org.eclipse.swtchart.export.core.ISeriesExportConverter;
import org.eclipse.swtchart.export.images.ImageSupplier;
import org.eclipse.swtchart.export.menu.bitmap.Messages;
import org.eclipse.swtchart.extensions.core.ScrollableChart;

public class JPGExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private static final String FILE_EXTENSION = "*.jpg";
    public static final String NAME = String.valueOf(Messages.getString("IMAGE")) + "*.jpg" + ")";
    private static final String TITLE = Messages.getString("SAVE_AS_IMAGE");

    public String getName() {
        return NAME;
    }

    public void execute(Shell shell, ScrollableChart scrollableChart) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(NAME);
        fileDialog.setFilterExtensions(new String[]{"*.jpeg", FILE_EXTENSION});
        String fileName = fileDialog.open();
        if (fileName != null) {
            ImageSupplier imageSupplier = new ImageSupplier();
            ImageData imageData = imageSupplier.getImageData(scrollableChart.getBaseChart());
            imageSupplier.saveImage(imageData, fileName, 4);
            MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)MESSAGE_OK);
        }
    }
}

