/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.images;

import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.images.ImageSupplier;

public class ImageFactory<T extends ScrollableChart> {
    private T t;
    private ImageSupplier imageSupplier;

    public ImageFactory(Class<T> clazz, int width, int height) throws InstantiationException, IllegalAccessException {
        this.t = (ScrollableChart)clazz.newInstance();
        this.imageSupplier = new ImageSupplier();
        Display display = ((ScrollableChart)this.t).getBaseChart().getDisplay();
        if (display != null) {
            width = width > display.getBounds().width ? display.getBounds().width : width;
            height = height > display.getBounds().height ? display.getBounds().height : height;
            this.t.getShell().setSize(width, height);
        }
    }

    public T getChart() {
        return this.t;
    }

    public void closeShell() {
        this.t.getShell().close();
    }

    public ImageData getImageData() {
        this.t.getShell().open();
        return this.imageSupplier.getImageData(((ScrollableChart)this.t).getBaseChart());
    }

    public void saveImage(String fileName, int format) {
        ImageData imageData = this.getImageData();
        this.imageSupplier.saveImage(imageData, fileName, format);
    }
}

