/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.util;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;

public class ImageDataStream
extends InputStream {
    private final BufferedImage image;
    private final int width;
    private final int height;
    private final Interleaving interleaving;
    private final Raster raster;
    private final boolean opaque;
    private final Queue<Integer> byteBuffer;
    private final int[] sampleValues;
    private final int[] sampleSizes;
    private int x;
    private int y;

    public ImageDataStream(BufferedImage image, Interleaving interleaving) {
        this.image = image;
        this.interleaving = interleaving;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.x = -1;
        this.y = 0;
        WritableRaster alphaRaster = image.getAlphaRaster();
        this.raster = interleaving == Interleaving.ALPHA_ONLY ? alphaRaster : image.getRaster();
        this.opaque = alphaRaster == null;
        this.byteBuffer = new LinkedList<Integer>();
        this.sampleValues = new int[this.raster.getNumBands()];
        this.sampleSizes = this.raster.getSampleModel().getSampleSize();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Interleaving getInterleaving() {
        return this.interleaving;
    }

    @Override
    public int read() {
        if (!this.byteBuffer.isEmpty()) {
            return this.byteBuffer.poll();
        }
        if (!this.nextSample()) {
            return -1;
        }
        int bands = this.sampleValues.length;
        if (this.interleaving == Interleaving.WITHOUT_ALPHA || this.interleaving == Interleaving.ALPHA_ONLY) {
            if (this.interleaving == Interleaving.WITHOUT_ALPHA && !this.opaque) {
                --bands;
            }
            int band = 0;
            while (band < bands) {
                this.bufferSampleValue(band);
                ++band;
            }
        } else if (this.opaque) {
            int band = 0;
            while (band < bands) {
                this.bufferSampleValue(band);
                ++band;
            }
        } else {
            int band = 0;
            while (band < bands) {
                if (band == 0) {
                    this.bufferSampleValue(bands - 1);
                } else {
                    this.bufferSampleValue(band - 1);
                }
                ++band;
            }
        }
        if (!this.byteBuffer.isEmpty()) {
            return this.byteBuffer.poll();
        }
        return -1;
    }

    private void bufferSampleValue(int band) {
        if (this.sampleSizes[band] < 8) {
            int byteValue = this.sampleValues[band] & 0xFF;
            this.byteBuffer.offer(byteValue);
        } else {
            int byteCount = this.sampleSizes[band] / 8;
            int i = byteCount - 1;
            while (i >= 0) {
                int byteValue = this.sampleValues[band] >> i * 8 & 0xFF;
                this.byteBuffer.offer(byteValue);
                --i;
            }
        }
    }

    private boolean nextSample() {
        if (this.interleaving == Interleaving.SAMPLE || this.interleaving == Interleaving.WITHOUT_ALPHA) {
            ++this.x;
            if (this.x >= this.width) {
                this.x = 0;
                ++this.y;
            }
        }
        if (this.x < 0 || this.x >= this.width || this.y < 0 || this.y >= this.height) {
            return false;
        }
        this.raster.getPixel(this.x, this.y, this.sampleValues);
        return true;
    }

    public static enum Interleaving {
        SAMPLE,
        ROW,
        WITHOUT_ALPHA,
        ALPHA_ONLY;

    }
}

