/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.model.internal.flash.proxy.ProxyManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ProxyPlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    private static ProxyPlugin plugin;
    private static ProxyManager proxyManager;
    private List<IPropertyChangeListener> listeners;
    public static final ImageDescriptor IMAGE_CLEAR;

    static {
        proxyManager = new ProxyManager();
        IMAGE_CLEAR = ProxyPlugin.getImageDescriptor("icons/action16/clear.gif");
    }

    public ProxyPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("ProxyType".equals(propertyChangeEvent.getProperty()) || "ProxySWFMethod".equals(propertyChangeEvent.getProperty()) || "SWFMinimumVersion".equals(propertyChangeEvent.getProperty()) || "Timeout".equals(propertyChangeEvent.getProperty()) || "PROXY_PORT".equals(propertyChangeEvent.getProperty())) {
                    ProxyPlugin.this.setProxySettings();
                }
            }
        });
        ProxyPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ProxyPlugin.this.setProxySettings();
            }
        });
    }

    private void setProxySettings() {
        proxyManager.stopProxy();
        String string = this.getPreferenceStore().getString("ProxyType");
        int n = this.getPreferenceStore().getInt("SWFMinimumVersion");
        int n2 = this.getPreferenceStore().getInt("Timeout");
        int n3 = this.getPreferenceStore().getInt("PROXY_PORT");
        if (!"PROXY_NONE".equals(string)) {
            String string2 = this.getPreferenceStore().getString("ProxySWFMethod");
            boolean bl = false;
            boolean bl2 = false;
            if ("PROXY_SWF_METHOD_BOOTLOADER".equals(string2)) {
                bl = true;
            } else if ("PROXY_SWF_METHOD_TRANSCODER".equals(string2)) {
                bl2 = true;
            }
            proxyManager.startProxy(n3, n, n2 * 1000, bl, bl2);
        }
        proxyManager.setInternetOptions("PROXY_GLOBAL".equals(string));
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        proxyManager.dispose();
        this.listeners = null;
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        plugin = null;
    }

    public static ProxyPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.model.flash.proxy", (String)string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = 0;
        while (n < this.listeners.size()) {
            this.listeners.get(n).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPropertyChangeListener>();
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.listeners.add(iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove(iPropertyChangeListener);
    }
}

