/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report;

import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ReportMessageDialog {
    public static void openReportMEssageDialog(Shell shell, IProblemItem iProblemItem) {
        if (shell == null || iProblemItem == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (Platform.inDevelopmentMode()) {
            stringBuffer.append(String.valueOf(iProblemItem.getId()) + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        }
        IGuidelineData[] iGuidelineDataArray = GuidelineHolder.getInstance().getGuidelineData();
        int n = 0;
        while (n < iGuidelineDataArray.length) {
            if (iGuidelineDataArray[n].isMatched()) {
                stringBuffer.append(String.valueOf(iGuidelineDataArray[n].getGuidelineName()) + ": " + iProblemItem.getTableDataGuideline()[n] + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
            }
            ++n;
        }
        stringBuffer.append(String.valueOf(IProblemConst.TITLE_TECHNIQUS) + ": " + iProblemItem.getEvaluationItem().getTableDataTechniques() + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        String string = iProblemItem.getLineStrMulti();
        if (string != null && string.length() > 0) {
            stringBuffer.append(String.valueOf(IProblemConst.TITLE_LINE) + ": " + string + FileUtils.LINE_SEP + FileUtils.LINE_SEP);
        }
        stringBuffer.append(String.valueOf(IProblemConst.TITLE_DESCRIPTION) + ": " + FileUtils.LINE_SEP + iProblemItem.getDescription());
        switch (iProblemItem.getSeverity()) {
            case 1: {
                MessageDialog.openError((Shell)shell, (String)IProblemConst.ESSENTIAL, (String)stringBuffer.toString());
                break;
            }
            case 2: {
                MessageDialog.openWarning((Shell)shell, (String)IProblemConst.WARNING, (String)stringBuffer.toString());
                break;
            }
            case 4: {
                MessageDialog.openInformation((Shell)shell, (String)IProblemConst.USER_CHECK, (String)stringBuffer.toString());
                break;
            }
            case 8: {
                MessageDialog.openInformation((Shell)shell, (String)IProblemConst.INFO, (String)stringBuffer.toString());
            }
        }
    }
}

