/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorSRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorXYZ;

public class ColorYXY {
    private float YY;
    private float x;
    private float y;

    public ColorYXY() {
    }

    public ColorYXY(float f, float f2, float f3) throws ColorException {
        this(f, f2, f3, false);
    }

    public ColorYXY(float f, float f2, float f3, boolean bl) throws ColorException {
        this.setYY(f, bl);
        this.setX(f2, bl);
        this.setY(f3, bl);
    }

    public float getYY() {
        return this.YY;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setYY(float f) throws ColorException {
        this.setYY(f, false);
    }

    public void setYY(float f, boolean bl) throws ColorException {
        if (f < 0.0f) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.YY = 0.0f;
        } else if (1.0f < f) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.YY = 1.0f;
        } else {
            this.YY = f;
        }
    }

    public void setX(float f) throws ColorException {
        this.setX(f, false);
    }

    public void setX(float f, boolean bl) throws ColorException {
        if (f < 0.0f) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.x = 0.0f;
        } else if (1.0f < f) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.x = 1.0f;
        } else {
            this.x = f;
        }
    }

    public void setY(float f) throws ColorException {
        this.setY(f, false);
    }

    public void setY(float f, boolean bl) throws ColorException {
        if (f < 0.0f) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.y = 0.0f;
        } else if (1.0f < f) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.y = 1.0f;
        } else {
            this.y = f;
        }
    }

    public ColorXYZ toXYZ() throws ColorException {
        return this.toXYZ(false);
    }

    public ColorXYZ toXYZ(boolean bl) throws ColorException {
        ColorXYZ colorXYZ = new ColorXYZ();
        if (this.y == 0.0f) {
            colorXYZ.setX(0.0f);
            colorXYZ.setY(0.0f);
            colorXYZ.setZ(0.0f);
        } else {
            colorXYZ.setX(this.YY / this.y * this.x, bl);
            colorXYZ.setY(this.YY, bl);
            colorXYZ.setZ(this.YY / this.y * (1.0f - this.x - this.y), bl);
        }
        return colorXYZ;
    }

    public ColorSRGB toSRGB() throws ColorException {
        return this.toSRGB(false);
    }

    public ColorSRGB toSRGB(boolean bl) throws ColorException {
        return this.toXYZ(bl).toSRGB(bl);
    }

    public ColorIRGB toIRGB() throws ColorException {
        return this.toIRGB(false);
    }

    public ColorIRGB toIRGB(boolean bl) throws ColorException {
        return this.toXYZ(bl).toSRGB(bl).toIRGB(bl);
    }
}

