/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.vocab.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.IProposition;

public class Function
implements IProposition {
    private String name;
    private Object[] args;
    private Method method;

    public Function(String name, String ... args) {
        this.name = name;
        this.args = new Object[args.length + 1];
        int i = 0;
        while (i < args.length) {
            this.args[i + 1] = args[i];
            ++i;
        }
    }

    public boolean eval(IEvalTarget node) {
        if (this.method == null) {
            Class[] classes = new Class[this.args.length];
            int i = 0;
            while (i < classes.length) {
                classes[i] = this.args[i].getClass();
                ++i;
            }
            Class<?> clazz = node.getTerms().getClass();
            try {
                this.method = clazz.getMethod(this.getName(), classes);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (this.method != null) {
            try {
                this.args[0] = node;
                return (Boolean)this.method.invoke((Object)node.getTerms(), this.args);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }
}

