/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import java.util.ArrayList;
import org.eclipse.actf.ai.internal.ui.scripteditor.ScriptListCellModifier;
import org.eclipse.actf.ai.internal.ui.scripteditor.ScriptListLabelProvider;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.ui.scripteditor.views.EditPanelView;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ScriptListTable {
    private EditPanelView instParentView = EditPanelView.getInstance();
    private Composite instParentComposite;
    private ScriptData instScriptData;
    private TableViewer instScriptListTblViewer;
    private Table instScriptListTbl;
    private TableItem[] instTableItems;
    private int previousIndexScript = 0;
    private int currentIndexScript = 0;
    private Color onHighLight;
    private Color offHighLight;
    private boolean current_select_mode = false;

    public ScriptListTable(Composite parentComposite) {
        this.instParentComposite = parentComposite;
        this.instScriptData = ScriptData.getInstance();
        this.instScriptListTblViewer = new TableViewer(this.instParentComposite, 67586);
        this.instScriptListTbl = this.instScriptListTblViewer.getTable();
        this.initTable();
    }

    private void initTable() {
        FormData ScriptTableLData = new FormData();
        ScriptTableLData.top = new FormAttachment(0, 1000, 2);
        ScriptTableLData.left = new FormAttachment(0, 1000, 2);
        ScriptTableLData.right = new FormAttachment(1000, 1000, -2);
        ScriptTableLData.bottom = new FormAttachment(1000, 1000, -2);
        this.instScriptListTbl.setLayoutData((Object)ScriptTableLData);
        TableColumn col1 = new TableColumn(this.instScriptListTbl, 0x1000000);
        col1.setText("WAV");
        col1.setWidth(40);
        TableColumn col2 = new TableColumn(this.instScriptListTbl, 0x1000000);
        col2.setText("Extended");
        col2.setWidth(70);
        TableColumn col3 = new TableColumn(this.instScriptListTbl, 16384);
        col3.setText("Start Time");
        col3.setWidth(78);
        TableColumn col4 = new TableColumn(this.instScriptListTbl, 16384);
        col4.setText("Description");
        col4.setWidth(415);
        TableColumn col5 = new TableColumn(this.instScriptListTbl, 16384);
        col5.setText("Comment");
        col5.setWidth(415);
        this.instScriptListTbl.setHeaderVisible(true);
        this.instScriptListTbl.setLinesVisible(true);
        String[] columnProperties = new String[]{"wav", "extended", "stime", "description", "comment"};
        this.instScriptListTblViewer.setColumnProperties(columnProperties);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)this.instScriptListTbl), new TextCellEditor((Composite)this.instScriptListTbl), new TextCellEditor((Composite)this.instScriptListTbl), new TextCellEditor((Composite)this.instScriptListTbl), new TextCellEditor((Composite)this.instScriptListTbl)};
        this.instScriptListTblViewer.setCellEditors(cellEditors);
        this.instScriptListTblViewer.setCellModifier((ICellModifier)new ScriptListCellModifier(this.instScriptListTblViewer));
        this.instScriptListTblViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.instScriptListTblViewer.setLabelProvider((IBaseLabelProvider)new ScriptListLabelProvider());
        this.instScriptListTblViewer.addSelectionChangedListener((ISelectionChangedListener)new ScriptListSlectionChangedListener());
        this.onHighLight = Display.getCurrent().getSystemColor(34);
        this.offHighLight = Display.getCurrent().getSystemColor(1);
    }

    public void reloadScriptList() {
        int maxData;
        ArrayList<ScriptData> currentScriptList = new ArrayList<ScriptData>();
        ScriptData columnScriptData = null;
        if (this.instTableItems != null) {
            int i = 0;
            while (i < this.instTableItems.length) {
                this.instTableItems[i] = null;
                ++i;
            }
        }
        if ((maxData = this.instScriptData.getLengthScriptList()) > 0) {
            int i = 0;
            while (i < maxData) {
                columnScriptData = new ScriptData();
                String nowScriptData = new String(this.instScriptData.getScriptData(i));
                int intScriptStartTime = this.instScriptData.getScriptStartTime(i);
                int intScriptEndTime = this.instScriptData.getScriptEndTime(i);
                String strScriptComment = this.instScriptData.getScriptComment(i);
                columnScriptData.appendScriptData(nowScriptData, intScriptStartTime, intScriptEndTime, strScriptComment);
                currentScriptList.add(columnScriptData);
                ++i;
            }
            this.instScriptListTblViewer.setInput(currentScriptList);
        } else {
            this.instScriptListTblViewer.setInput(currentScriptList);
        }
        this.instTableItems = this.instScriptListTbl.getItems();
    }

    public void setCurrentSelectionMode(boolean newMode) {
        this.current_select_mode = newMode;
    }

    public void clearHighLightScriptLine() {
        this.setBackgroundColorScriptLine(this.previousIndexScript, false);
        this.setBackgroundColorScriptLine(this.currentIndexScript, false);
        this.previousIndexScript = 0;
        this.currentIndexScript = 0;
    }

    public void updateHighLightScriptLine(int nextIndex) {
        this.setBackgroundColorScriptLine(this.currentIndexScript, false);
        this.setCurrentScriptIndex(nextIndex);
        this.setBackgroundColorScriptLine(this.currentIndexScript, true);
    }

    private void setCurrentScriptIndex(int nextIndex) {
        if (nextIndex >= 0 && nextIndex < this.instScriptData.getLengthScriptList()) {
            this.previousIndexScript = this.currentIndexScript;
            this.currentIndexScript = nextIndex;
        }
    }

    private void setBackgroundColorScriptLine(int index, boolean swHighLight) {
        if (this.instTableItems != null && this.instTableItems.length > index) {
            this.instTableItems[index].setBackground(swHighLight ? this.onHighLight : this.offHighLight);
        }
    }

    class ScriptListSlectionChangedListener
    implements ISelectionChangedListener {
        ScriptListSlectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent e) {
            IStructuredSelection sel = (IStructuredSelection)e.getSelection();
            Object[] objs = sel.toArray();
            if (objs.length == 1) {
                this.selectSingleItem(e, (ScriptData)objs[0]);
            } else if (objs.length > 1) {
                this.selectMultiItems(objs);
            }
        }

        private void selectSingleItem(SelectionChangedEvent e, ScriptData targetData) {
            int index = ScriptListTable.this.instScriptData.searchScriptData(targetData.getScriptStartTime(0));
            if (index >= 0) {
                if (ScriptListTable.this.current_select_mode) {
                    ScriptListTable.this.current_select_mode = false;
                    ScriptListTable.this.instParentView.getInstanceTabEditPanel().endSelectMultiItems();
                }
                ScriptListTable.this.instParentView.getInstanceTabEditPanel().repaintTextScriptData(index);
                ScriptListTable.this.instParentView.getInstanceTabSelWAVFile().repaintDescriptionStruct(index);
                TimeLineView.getInstance().reqUpdateLocationTimeLine(index);
            }
        }

        private void selectMultiItems(Object[] targetDatas) {
            if (!ScriptListTable.this.current_select_mode) {
                ScriptListTable.this.current_select_mode = true;
                ScriptListTable.this.instParentView.getInstanceTabEditPanel().startSelectMultiItems(targetDatas);
            } else {
                ScriptListTable.this.instParentView.getInstanceTabEditPanel().appendSelectMultiItems(targetDatas);
            }
        }
    }
}

