/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.EventManager;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEventListener;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.TimerEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.TimerEventListener;
import org.eclipse.actf.ai.scripteditor.preferences.CapturePreferenceUtil;
import org.eclipse.actf.ai.scripteditor.util.SoundMixer;
import org.eclipse.actf.ai.scripteditor.util.TempFileUtil;
import org.eclipse.actf.ai.ui.scripteditor.views.EditPanelView;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class VolumeLevelCanvas
extends Canvas
implements IUNIT,
SyncTimeEventListener,
TimerEventListener {
    private static VolumeLevelCanvas ownInst = null;
    private int currentProcStatus = 0;
    private Image offImage = null;
    private int borderLinePosX = 0;
    private ArrayList<Integer> sampleVolumeLevel;
    private ArrayList<Integer> startTimeCaptureAudio;
    private ArrayList<Integer> volumeLevelCaptureAudio;
    private int previewVoiceTotalTime = 0;
    private float currentVolLvlGain = 1.0f;
    private URI savePathVolLvl = null;
    private boolean currentCaptureMode = true;
    private int timerUtilCounter = 0;
    private int currentTimeLineLocation = 0;
    private int ownFreeRunTimeCount = 0;
    private int ownFreeRunLimitCount = 0;
    private int previousParentTimeLine = 0;
    private int previousDrawTime = 0;
    private int previousDrawSize = 0;
    private Point previousCanvasSize;
    private TimeLineView instParentView;
    private EventManager eventManager = null;

    public VolumeLevelCanvas(Composite parent) {
        super(parent, 2048);
        ownInst = this;
        this.eventManager = EventManager.getInstance();
        this.initializeCanvas(parent);
        this.instParentView = TimeLineView.getInstance();
        if (this.getCurrentCaptureMode()) {
            this.startTimerCaptureAudio();
        }
        this.setCurrentVolLvlGain(CapturePreferenceUtil.getPreferenceVolLvlGain());
        this.eventManager.addSyncTimeEventListener(this);
        this.eventManager.addTimerEventListener(this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VolumeLevelCanvas.this.eventManager.removeSyncTimeEventListener(ownInst);
                VolumeLevelCanvas.this.eventManager.removeTimerEventListener(ownInst);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VolumeLevelCanvas getInstance(Composite parent) {
        if (ownInst != null) return ownInst;
        Class<VolumeLevelCanvas> clazz = VolumeLevelCanvas.class;
        synchronized (VolumeLevelCanvas.class) {
            if (ownInst != null) return ownInst;
            ownInst = new VolumeLevelCanvas(parent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ownInst;
        }
    }

    public static VolumeLevelCanvas getInstance() {
        return ownInst;
    }

    private void initializeCanvas(Composite parent) {
        try {
            this.currentProcStatus = 0;
            this.setLocationBorderTimeLine(0);
            this.addPaintListener(new CanvasPaintListener());
            this.sampleVolumeLevel = new ArrayList();
            this.startTimeCaptureAudio = new ArrayList();
            this.volumeLevelCaptureAudio = new ArrayList();
            this.previousCanvasSize = this.getSize();
        }
        catch (Exception ef) {
            System.out.println("initializeCanvas : Exception = " + ef);
        }
    }

    public void synchronizeTimeLine(int nowTime) {
        int x = (nowTime - this.currentTimeLineLocation * 300000) / 20;
        this.setLocationBorderTimeLine(x);
    }

    public void refreshTimeLine(int nowCnt) {
        this.currentTimeLineLocation = nowCnt;
        this.setStatusCanvasVolumeLevel(2);
    }

    public void setStatusCanvasVolumeLevel(int nextStatus) {
        this.currentProcStatus = nextStatus;
        this.redraw();
    }

    private void setLocationBorderTimeLine(int x) {
        this.borderLinePosX = x - 1;
        if (this.borderLinePosX < 0) {
            this.borderLinePosX = 0;
        }
        this.redraw();
    }

    public int getSamplingLengthVolumeLevel() {
        return this.previewVoiceTotalTime;
    }

    public void clearSamplingLengthVolumeLevel() {
        this.previewVoiceTotalTime = 0;
    }

    public boolean getCurrentCaptureMode() {
        return this.currentCaptureMode;
    }

    public void setCurrentCaptureMode(boolean stat) {
        this.currentCaptureMode = stat;
    }

    public void setCurrentVolLvlGain(int newGain) {
        this.currentVolLvlGain = (float)newGain / 100.0f;
    }

    public void cleanupMovieAudioLevel() {
        this.startTimeCaptureAudio.clear();
        this.volumeLevelCaptureAudio.clear();
    }

    public int getSamplingLengthMovieAudioLevel() {
        int result = -1;
        if (!this.startTimeCaptureAudio.isEmpty()) {
            result = this.startTimeCaptureAudio.size();
        }
        return result;
    }

    private void drawBorderLine(PaintEvent e) {
        Point nowCanvas = this.getSize();
        e.gc.setBackground(e.display.getSystemColor(9));
        e.gc.fillRectangle(this.borderLinePosX, 0, 2, nowCanvas.y);
    }

    private void initCanvasVolumeLevel(PaintEvent e) {
        int endTimeLine = 600000;
        Point nowCanvas = this.getSize();
        Point newCanvas = new Point(endTimeLine / 20, nowCanvas.y);
        if (e.width > newCanvas.x) {
            newCanvas = null;
            newCanvas = this.getSize();
        }
        if (this.offImage != null) {
            this.offImage.dispose();
            this.offImage = null;
        }
        this.offImage = new Image((Device)this.getDisplay(), newCanvas.x, newCanvas.y);
        GC wgc = new GC((Drawable)this.offImage);
        Rectangle rectWGC = new Rectangle(0, 0, newCanvas.x, newCanvas.y);
        wgc.setBackground(e.display.getSystemColor(1));
        wgc.fillRectangle(rectWGC);
        wgc.setForeground(e.display.getSystemColor(9));
        wgc.drawLine(0, newCanvas.y >> 1, newCanvas.x, newCanvas.y >> 1);
        e.gc.drawImage(this.offImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
        wgc.dispose();
        Point ownSize = ((Canvas)e.getSource()).getSize();
        this.instParentView.setPositionLabelVolumeLevel(ownSize.y >> 1);
        this.currentProcStatus = 4;
    }

    private void drawMediaAudioLevel(PaintEvent e) {
        int endTimeLine = 600000;
        Point nowCanvas = this.getSize();
        Point newCanvas = new Point(endTimeLine / 20, nowCanvas.y);
        if (e.width > newCanvas.x) {
            newCanvas = null;
            newCanvas = this.getSize();
        }
        int ht = newCanvas.y;
        int cHt = ht >> 1;
        int adjHt = Short.MAX_VALUE / (cHt + 1) + 1;
        if (this.offImage != null) {
            this.offImage.dispose();
            this.offImage = null;
        }
        this.offImage = new Image((Device)this.getDisplay(), newCanvas.x, newCanvas.y);
        GC wgc = new GC((Drawable)this.offImage);
        Rectangle rectWGC = new Rectangle(0, 0, newCanvas.x, newCanvas.y);
        wgc.setBackground(e.display.getSystemColor(1));
        wgc.fillRectangle(rectWGC);
        wgc.setForeground(e.display.getSystemColor(9));
        wgc.drawLine(0, newCanvas.y >> 1, newCanvas.x, newCanvas.y >> 1);
        this.instParentView.setPositionLabelVolumeLevel(cHt);
        wgc.setForeground(new Color((Device)e.display, 120, 150, 255));
        int audioLevel = 0;
        int startTime = this.currentTimeLineLocation * 300000;
        int dx = 0;
        int datasize = this.startTimeCaptureAudio.size();
        int startIndex = 0;
        while (startIndex < datasize) {
            audioLevel = this.startTimeCaptureAudio.get(startIndex);
            if (audioLevel >= startTime) break;
            ++startIndex;
        }
        int i = startIndex;
        while (i < datasize) {
            float tempLevel;
            audioLevel = this.volumeLevelCaptureAudio.get(i);
            if ((audioLevel /= adjHt) < 0) {
                audioLevel *= -1;
            }
            if ((audioLevel = (int)(tempLevel = (float)audioLevel * this.currentVolLvlGain)) > 0) {
                startTime = this.startTimeCaptureAudio.get(i);
                dx = (startTime - this.currentTimeLineLocation * 300000) / 20;
                wgc.drawLine(dx, cHt - audioLevel, dx, cHt + audioLevel);
            }
            ++i;
        }
        e.gc.drawImage(this.offImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
        wgc.dispose();
        this.previousDrawTime = startTime;
        this.previousDrawSize = datasize;
        this.currentProcStatus = 1 == this.instParentView.getStatusTimeLine() ? (this.getCurrentCaptureMode() ? 3 : 4) : 4;
    }

    private void drawAppendMediaAudioLevel(PaintEvent e) {
        GC wgc = new GC((Drawable)this.offImage);
        int datasize = this.startTimeCaptureAudio.size();
        if (datasize - this.previousDrawSize > 0) {
            Point nowCanvas = this.getSize();
            int ht = nowCanvas.y;
            int cHt = ht >> 1;
            int adjHt = Short.MAX_VALUE / (cHt + 1) + 1;
            wgc.setForeground(new Color((Device)e.display, 120, 150, 255));
            int audioLevel = 0;
            int startTime = 0;
            int initTime = this.startTimeCaptureAudio.indexOf(this.previousDrawTime);
            if (initTime < 0) {
                initTime = 0;
            }
            int dx = 0;
            int i = initTime;
            while (i < datasize) {
                float tempLevel;
                audioLevel = this.volumeLevelCaptureAudio.get(i);
                if ((audioLevel /= adjHt) < 0) {
                    audioLevel *= -1;
                }
                if ((audioLevel = (int)(tempLevel = (float)audioLevel * this.currentVolLvlGain)) > 0) {
                    startTime = this.startTimeCaptureAudio.get(i);
                    dx = (startTime - this.currentTimeLineLocation * 300000) / 20;
                    wgc.drawLine(dx, cHt - audioLevel, dx, cHt + audioLevel);
                }
                ++i;
            }
            this.previousDrawSize = datasize;
            this.previousDrawTime = startTime;
        }
        e.gc.drawImage(this.offImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
        wgc.dispose();
    }

    private void redrawCurrentOffImage(PaintEvent e) {
        if (this.offImage != null) {
            e.gc.drawImage(this.offImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
        }
    }

    private void drawPreviewDataVolumeLevel(PaintEvent e) {
        Point nowCanvas = this.getSize();
        int ht = nowCanvas.y;
        int cHt = ht >> 1;
        int wd = nowCanvas.x;
        e.gc.setBackground(e.display.getSystemColor(1));
        e.gc.setForeground(e.display.getSystemColor(9));
        e.gc.drawLine(0, cHt, wd, cHt);
        this.instParentView.setPositionLabelVolumeLevel(cHt);
        e.gc.setForeground(new Color((Device)e.display, 120, 150, 255));
        int audioLevel = 0;
        int dx = 0;
        int startTimeLine = TimeLineView.getInstance().getStartTimeLine();
        int nowStartTime = startTimeLine / 1000;
        while (nowStartTime < this.sampleVolumeLevel.size()) {
            audioLevel = this.sampleVolumeLevel.get(nowStartTime);
            if (audioLevel > 0) {
                e.gc.drawLine(dx, cHt - audioLevel, dx, cHt + audioLevel);
            }
            ++dx;
            ++nowStartTime;
        }
    }

    public void samplingTimerTask() {
        if (this.instParentView.isSamplingScriptAudio().booleanValue()) {
            ++this.previewVoiceTotalTime;
        } else if (5 != this.instParentView.getStatusTimeLine()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EditPanelView.getInstance().getInstanceTabEditPanel().repaintTextEndTime();
                }
            });
        }
    }

    private boolean startTimerCaptureAudio() {
        this.currentCaptureMode = true;
        return true;
    }

    private void updateFreeRunCounter(int duration) {
        int nowParentTimeLine = this.instParentView.getCurrentTimeLine();
        if (this.previousParentTimeLine != nowParentTimeLine) {
            this.previousParentTimeLine = nowParentTimeLine;
            this.ownFreeRunTimeCount = nowParentTimeLine;
            this.ownFreeRunLimitCount = 0;
        } else if (this.ownFreeRunLimitCount <= 5) {
            this.ownFreeRunTimeCount += duration;
            ++this.ownFreeRunLimitCount;
        }
    }

    private void updateCaptureAudio(int currentTime) {
        int audioLevel = SoundMixer.getInstance().pickupCaptureAudioLevel();
        int quantumStartTime = currentTime - currentTime % 20;
        if (audioLevel >= 0) {
            if (!this.startTimeCaptureAudio.isEmpty()) {
                int index = this.startTimeCaptureAudio.indexOf(quantumStartTime);
                if (index >= 0) {
                    this.volumeLevelCaptureAudio.set(index, audioLevel);
                } else {
                    this.startTimeCaptureAudio.add(quantumStartTime);
                    this.volumeLevelCaptureAudio.add(audioLevel);
                }
            } else {
                this.startTimeCaptureAudio.add(quantumStartTime);
                this.volumeLevelCaptureAudio.add(audioLevel);
            }
        }
    }

    private void captureAudioTimerTask() {
        if (this.getCurrentCaptureMode() && 1 == this.instParentView.getStatusTimeLine()) {
            this.updateFreeRunCounter(20);
            this.updateCaptureAudio(this.ownFreeRunTimeCount);
        }
    }

    public void saveVolumeLevelTempFile() {
        try {
            String fpath = null;
            if (this.getSamplingLengthMovieAudioLevel() > 0) {
                if (this.savePathVolLvl == null) {
                    File fh = TempFileUtil.createTempFile("VOLLVL", "temp", ".lvl");
                    if (fh != null) {
                        fpath = fh.getAbsolutePath();
                    }
                } else {
                    fpath = this.savePathVolLvl.getPath();
                    fpath = fpath.replace("/", "\\");
                }
                if (fpath != null) {
                    TempFileUtil.writeStreamTempFile(this.startTimeCaptureAudio, this.volumeLevelCaptureAudio, fpath);
                    this.savePathVolLvl = TempFileUtil.getResource(fpath);
                }
            }
        }
        catch (Exception ee) {
            System.out.println("saveVolumeLevelTempFile() : " + ee);
        }
    }

    public URI getSavePathVolLvl() {
        return this.savePathVolLvl;
    }

    public void setSavePathVolLvl(String fpath) {
        this.savePathVolLvl = null;
        if (fpath != null) {
            this.savePathVolLvl = TempFileUtil.getResource(fpath);
        }
    }

    public boolean isEnableClearVolLvl() {
        boolean result = false;
        if (this.savePathVolLvl == null) {
            result = true;
        }
        return result;
    }

    public void loadVolumeLevelTempFile() {
        if (this.savePathVolLvl != null) {
            String fpath = this.savePathVolLvl.getPath();
            fpath = fpath.replace("/", "\\");
            try {
                this.cleanupMovieAudioLevel();
                if (TempFileUtil.openInputStreamTempFile(fpath)) {
                    int startTime;
                    while ((startTime = TempFileUtil.readIntValueTempFile()) >= 0) {
                        int volLvl = TempFileUtil.readIntValueTempFile();
                        this.startTimeCaptureAudio.add(startTime);
                        this.volumeLevelCaptureAudio.add(volLvl);
                    }
                    TempFileUtil.closeInputStreamTempFile();
                }
            }
            catch (Exception ee) {
                System.out.println("loadVolumeLevelTempFile() : " + ee);
            }
        }
    }

    @Override
    public void handleSyncTimeEvent(SyncTimeEvent e) {
        if (e.getEventType() == 0) {
            this.synchronizeTimeLine(e.getCurrentTime());
        } else if (e.getEventType() == 1) {
            this.refreshTimeLine(e.getCurrentTime());
        }
    }

    @Override
    public void handleTimerUtilEvent(TimerEvent e) {
        this.timerUtilCounter += 10;
        if (this.timerUtilCounter >= 20) {
            this.samplingTimerTask();
            this.captureAudioTimerTask();
            this.timerUtilCounter = 0;
        }
    }

    class CanvasPaintListener
    implements PaintListener {
        CanvasPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            try {
                if (VolumeLevelCanvas.this.offImage == null) {
                    VolumeLevelCanvas.this.currentProcStatus = 1;
                } else if (((VolumeLevelCanvas)VolumeLevelCanvas.this).previousCanvasSize.x != e.width || ((VolumeLevelCanvas)VolumeLevelCanvas.this).previousCanvasSize.y != e.height) {
                    if (VolumeLevelCanvas.this.currentProcStatus > 1) {
                        VolumeLevelCanvas.this.currentProcStatus = 2;
                    }
                    ((VolumeLevelCanvas)VolumeLevelCanvas.this).previousCanvasSize.x = e.width;
                    ((VolumeLevelCanvas)VolumeLevelCanvas.this).previousCanvasSize.y = e.height;
                }
                if (VolumeLevelCanvas.this.currentProcStatus == 1) {
                    VolumeLevelCanvas.this.initCanvasVolumeLevel(e);
                } else if (VolumeLevelCanvas.this.currentProcStatus == 2) {
                    VolumeLevelCanvas.this.drawMediaAudioLevel(e);
                } else if (VolumeLevelCanvas.this.currentProcStatus == 3) {
                    VolumeLevelCanvas.this.drawAppendMediaAudioLevel(e);
                } else if (VolumeLevelCanvas.this.currentProcStatus == 4) {
                    VolumeLevelCanvas.this.redrawCurrentOffImage(e);
                } else if (VolumeLevelCanvas.this.currentProcStatus == 11) {
                    VolumeLevelCanvas.this.drawPreviewDataVolumeLevel(e);
                }
                VolumeLevelCanvas.this.drawBorderLine(e);
                e.gc.dispose();
            }
            catch (Exception ee) {
                System.out.println(">>VolumeCanvas::paintControl() : " + ee);
            }
        }
    }
}

