/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.actf.ai.internal.ui.scripteditor.PreviewPanel;
import org.eclipse.actf.ai.internal.ui.scripteditor.XMLFileMessageBox;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;

public class XMLFileSaveUtil
implements IUNIT {
    private String[] EXTENSIONS = new String[]{"*.xml", "*"};
    private ScriptData instScriptData = null;
    private PreviewPanel instPreviewPanel = null;
    private TimeLineView instTimeLine = null;

    public XMLFileSaveUtil() {
        this.pickupInstViewPart();
    }

    public static boolean exists(String filePath) {
        boolean result = false;
        if (filePath != null) {
            try {
                File fh = new File(filePath);
                if (fh.exists()) {
                    result = true;
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public String open() {
        String filePath = null;
        FileDialog saveDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        saveDialog.setFilterExtensions(this.EXTENSIONS);
        filePath = saveDialog.open();
        return filePath;
    }

    public boolean save(String filePath, boolean ovwr) {
        boolean result = false;
        if (filePath != null) {
            this.instTimeLine.reqSaveVolumeLevelTempFile();
            this.saveFile(filePath, ovwr);
            this.instTimeLine.reqStoreXMLFilePath(filePath);
            this.instScriptData.setStatusSaveScripts(5, false);
            result = true;
        }
        return result;
    }

    private void pickupInstViewPart() {
        if (this.instPreviewPanel == null) {
            this.instPreviewPanel = PreviewPanel.getInstance();
        }
        if (this.instScriptData == null) {
            this.instScriptData = ScriptData.getInstance();
        }
        if (this.instTimeLine == null) {
            this.instTimeLine = TimeLineView.getInstance();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveFile(String fname, boolean warnOverwrite) {
        PrintWriter writer;
        block16: {
            XMLFileMessageBox warningExistFile;
            int ret;
            writer = null;
            File file = new File(fname);
            if (!warnOverwrite || !file.exists() || (ret = (warningExistFile = new XMLFileMessageBox(2, fname)).open()) == 64) break block16;
            if (writer == null) return;
            try {
                writer.flush();
                writer.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        try {
            try {
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fname), "UTF-8"));
                String LINE_SEP = FileUtils.LINE_SEP;
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + LINE_SEP);
                writer.write("<puits xmlns=\"urn:puits\">" + LINE_SEP);
                writer.write("  <meta xmlns=\"http://www.ibm.com/xmlns/prod/AcTF/aiBrowser/selector/1.0\">" + LINE_SEP);
                String strURL = "about:blank";
                try {
                    strURL = this.instPreviewPanel.getURLMovie();
                }
                catch (Exception exception) {}
                writer.write("\t<targetSite uri=\"" + strURL + "\">" + LINE_SEP);
                writer.write("\t  <targetContent key=\"*\"/>" + LINE_SEP);
                writer.write("\t</targetSite>" + LINE_SEP);
                writer.write("  </meta>" + LINE_SEP);
                writer.write("  " + LINE_SEP);
                writer.write("  <alternative type=\"audio-description\">" + LINE_SEP);
                writer.write(this.instScriptData.toXMLfragment());
                writer.write("  </alternative>" + LINE_SEP);
                if (this.instTimeLine.reqGetVolLvlPath() != null) {
                    String strPath = this.instTimeLine.reqGetVolLvlPath().toString();
                    writer.write("  " + LINE_SEP);
                    writer.write("  <volumeLevel local=\"" + strPath + "\"/>" + LINE_SEP);
                }
                writer.write("</puits>" + LINE_SEP);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer == null) return;
                try {
                    writer.flush();
                    writer.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (writer == null) throw throwable;
            try {
                writer.flush();
                writer.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        if (writer == null) return;
        try {
            writer.flush();
            writer.close();
            return;
        }
        catch (Exception exception) {}
    }
}

