/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.dom;

import java.util.HashMap;
import org.eclipse.actf.util.dom.WhatToShowNodeFilter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class TreeWalkerImpl
implements TreeWalker {
    private Node walkerRoot;
    private Node current;
    private int whatToShow;
    private NodeFilter filter;
    private NodeFilter defaultFilter;
    private boolean entitiyReferenceExpansion;
    private boolean noFilter = true;
    private HashMap<Node, Node> parentMap = new HashMap();

    public TreeWalkerImpl(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        if (root == null) {
            throw new DOMException(9, "Root can't be a null.");
        }
        this.walkerRoot = root;
        this.current = root;
        this.whatToShow = whatToShow;
        this.filter = filter;
        this.noFilter = filter == null;
        this.entitiyReferenceExpansion = entityReferenceExpansion;
        this.defaultFilter = new WhatToShowNodeFilter(whatToShow);
    }

    private short eval(Node target) {
        short flag = this.defaultFilter.acceptNode(target);
        if (this.noFilter || flag == 3) {
            return flag;
        }
        return this.filter.acceptNode(target);
    }

    private Node getVisibleNextSibling(Node target, Node root) {
        if (target == root) {
            return null;
        }
        Node tmpN = target.getNextSibling();
        if (tmpN == null) {
            Node tmpP = this.getParentNode(target);
            if (this.eval(tmpP) == 3) {
                return this.getVisibleNextSibling(tmpP, root);
            }
            return null;
        }
        switch (this.eval(tmpN)) {
            case 1: {
                return tmpN;
            }
            case 3: {
                Node tmpC = this.getVisibleFirstChild(tmpN);
                if (tmpC == null) break;
                return tmpC;
            }
        }
        return this.getVisibleNextSibling(tmpN, root);
    }

    private Node getVisiblePreviousSibling(Node target, Node root) {
        if (target == root) {
            return null;
        }
        Node tmpN = target.getPreviousSibling();
        if (tmpN == null) {
            Node tmpP = this.getParentNode(target);
            if (this.eval(tmpP) == 3) {
                return this.getVisiblePreviousSibling(tmpP, root);
            }
            return null;
        }
        switch (this.eval(tmpN)) {
            case 1: {
                return tmpN;
            }
            case 3: {
                Node tmpC = this.getVisibleLastChild(tmpN);
                if (tmpC == null) break;
                return tmpC;
            }
        }
        return this.getVisiblePreviousSibling(tmpN, root);
    }

    private Node getVisibleFirstChild(Node target) {
        if (!this.entitiyReferenceExpansion && 5 == target.getNodeType()) {
            return null;
        }
        Node tmpN = target.getFirstChild();
        if (tmpN == null) {
            return null;
        }
        this.parentMap.put(tmpN, target);
        Node tmpNext = tmpN.getNextSibling();
        while (tmpNext != null) {
            this.parentMap.put(tmpNext, target);
            tmpNext = tmpNext.getNextSibling();
        }
        switch (this.eval(tmpN)) {
            case 1: {
                return tmpN;
            }
            case 3: {
                Node tmpN2 = this.getVisibleFirstChild(tmpN);
                if (tmpN2 == null) break;
                return tmpN2;
            }
        }
        return this.getVisibleNextSibling(tmpN, target);
    }

    private Node getVisibleLastChild(Node target) {
        if (!this.entitiyReferenceExpansion && 5 == target.getNodeType()) {
            return null;
        }
        Node tmpN = target.getLastChild();
        if (tmpN == null) {
            return null;
        }
        switch (this.eval(tmpN)) {
            case 1: {
                return tmpN;
            }
            case 3: {
                Node tmpN2 = this.getVisibleLastChild(tmpN);
                if (tmpN2 == null) break;
                return tmpN2;
            }
        }
        return this.getVisiblePreviousSibling(tmpN, target);
    }

    private Node getVisibleParent(Node target) {
        if (target == this.walkerRoot) {
            return null;
        }
        Node tmpN = this.getParentNode(target);
        if (tmpN == null) {
            return null;
        }
        switch (this.eval(tmpN)) {
            case 1: {
                return tmpN;
            }
        }
        return this.getVisibleParent(tmpN);
    }

    protected Node getParentNode(Node target) {
        Node tmpN = this.parentMap.get(target);
        if (tmpN != null) {
            return tmpN;
        }
        return target.getParentNode();
    }

    public Node firstChild() {
        Node result = this.getVisibleFirstChild(this.current);
        if (result != null) {
            this.current = result;
        }
        return result;
    }

    public Node getCurrentNode() {
        return this.current;
    }

    public boolean getExpandEntityReferences() {
        return this.entitiyReferenceExpansion;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public Node getRoot() {
        return this.walkerRoot;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public Node lastChild() {
        Node result = this.getVisibleLastChild(this.current);
        if (result != null) {
            this.current = result;
        }
        return result;
    }

    public Node nextNode() {
        Node tmpN = this.getVisibleFirstChild(this.current);
        if (tmpN != null) {
            this.current = tmpN;
            return tmpN;
        }
        tmpN = this.getVisibleNextSibling(this.current, this.walkerRoot);
        if (tmpN != null) {
            this.current = tmpN;
            return tmpN;
        }
        Node tmpP = this.getVisibleParent(this.current);
        while (tmpP != null) {
            tmpN = this.getVisibleNextSibling(tmpP, this.walkerRoot);
            if (tmpN != null) {
                this.current = tmpN;
                return tmpN;
            }
            tmpP = this.getVisibleParent(tmpP);
        }
        return null;
    }

    public Node nextSibling() {
        Node result = this.getVisibleNextSibling(this.current, this.walkerRoot);
        if (result != null) {
            this.current = result;
        }
        return result;
    }

    public Node parentNode() {
        Node result = this.getVisibleParent(this.current);
        if (result != null) {
            this.current = result;
        }
        return result;
    }

    public Node previousNode() {
        Node tmpN = this.getVisiblePreviousSibling(this.current, this.walkerRoot);
        if (tmpN == null) {
            tmpN = this.getVisibleParent(this.current);
            if (tmpN != null) {
                this.current = tmpN;
                return tmpN;
            }
            return null;
        }
        Node tmpC = this.getVisibleLastChild(tmpN);
        while (tmpC != null) {
            tmpN = tmpC;
            tmpC = this.getVisibleLastChild(tmpN);
        }
        this.current = tmpN;
        return tmpN;
    }

    public Node previousSibling() {
        Node result = this.getVisiblePreviousSibling(this.current, this.walkerRoot);
        if (result != null) {
            this.current = result;
        }
        return result;
    }

    public void setCurrentNode(Node arg0) throws DOMException {
        if (arg0 == null) {
            throw new DOMException(9, "Current node can't be null.");
        }
        this.current = arg0;
    }
}

