/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.xpath;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathCreator {
    private static final String TEXT_NODE_NAME = "#text";
    private static final String TEXT_NODE = "text()";
    private static final String RIGHT_BRACKET = "]";
    private static final String LEFT_BRACKET = "[";
    private static final String SLASH = "/";

    public static String childPathSequence(Node target) {
        StringBuffer tmpSB = new StringBuffer();
        Document owner = null;
        if (target != null) {
            owner = target.getOwnerDocument();
        }
        while (target != null && target != owner) {
            String currentName = target.getNodeName();
            int count = XPathCreator.countSiblingByName(target, currentName);
            if (TEXT_NODE_NAME.equalsIgnoreCase(currentName)) {
                currentName = TEXT_NODE;
            }
            if (count > 0) {
                tmpSB.insert(0, SLASH + currentName + LEFT_BRACKET + ++count + RIGHT_BRACKET);
            } else {
                tmpSB.insert(0, SLASH + currentName);
            }
            target = target.getParentNode();
        }
        return tmpSB.toString();
    }

    private static int countSiblingByName(Node target, String name) {
        int count = 0;
        if (target != null) {
            target = target.getPreviousSibling();
        }
        while (target != null) {
            if (target.getNodeName().equals(name)) {
                ++count;
            }
            target = target.getPreviousSibling();
        }
        return count;
    }
}

