/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32.keyhook.impl;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.actf.util.win32.keyhook.IKeyHook;
import org.eclipse.actf.util.win32.keyhook.IKeyHookListener;

public class KeyHookImpl
implements IKeyHook {
    private static boolean initialized;
    private static HashSet<KeyHookImpl> hooks;
    private final IKeyHookListener keyHookListener;

    static {
        try {
            System.loadLibrary("KeyHook");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        initialized = false;
        hooks = new HashSet();
    }

    private static void register(KeyHookImpl inst) {
        hooks.add(inst);
    }

    public static synchronized boolean hookedKeyEntry(int idx, int vkey, int modifier, boolean isUp) {
        Iterator<KeyHookImpl> it = hooks.iterator();
        boolean filtered = false;
        while (it.hasNext()) {
            KeyHookImpl inst = it.next();
            boolean bl = filtered = inst.keyHookListener.hookedKey(vkey, modifier, isUp) || filtered;
        }
        return filtered;
    }

    public synchronized void registerHookedKey(int vkey, int modifier) {
        this.filterKey(0, vkey, modifier);
    }

    public synchronized void hookAll(boolean flag) {
        this.filterAllKey(flag);
    }

    public KeyHookImpl(IKeyHookListener keyHookListener, long hwnd) {
        if (!initialized) {
            this.initialize(hwnd);
            initialized = true;
        }
        KeyHookImpl.register(this);
        this.keyHookListener = keyHookListener;
    }

    private native void initialize(long var1);

    private native void filterKey(int var1, int var2, int var3);

    private native void filterAllKey(boolean var1);

    public synchronized void dispose() {
        hooks.remove(this);
    }
}

