/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.actf.model.dom.dombycom.IDocumentEx;
import org.eclipse.actf.model.dom.dombycom.IStyleSheets;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeListImpl;
import org.eclipse.actf.model.dom.dombycom.impl.StyleSheetImpl;
import org.eclipse.actf.model.dom.dombycom.impl.StyleSheetsImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.HTMLElementFactory;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IEnumUnknown;
import org.eclipse.actf.util.win32.comclutch.IOleContainer;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentImpl
extends NodeImpl
implements IDocumentEx {
    private IDispatch htmlDocument;
    private HashMap<String, NodeImpl> inodeMap = new HashMap();

    synchronized NodeImpl lookupNode(String uniqueName) {
        NodeImpl n = this.inodeMap.get(uniqueName);
        return n;
    }

    synchronized void regNode(String uniqueName, NodeImpl node) {
        this.inodeMap.put(uniqueName, node);
    }

    public DocumentImpl(IDispatch htmlDocument) {
        super(htmlDocument);
        this.htmlDocument = htmlDocument;
    }

    @Override
    public IStyleSheets getStyleSheets() {
        IDispatch inode = (IDispatch)Helper.get(this.htmlDocument, "styleSheets");
        return new StyleSheetsImpl(inode);
    }

    @Override
    public Element getDocumentElement() {
        IDispatch inode = (IDispatch)Helper.get(this.htmlDocument, "documentElement");
        return (Element)((Object)this.newNode(inode, (short)1));
    }

    @Override
    public DocumentType getDoctype() {
        return null;
    }

    @Override
    public DOMImplementation getImplementation() {
        return null;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return null;
    }

    @Override
    public Text createTextNode(String data) {
        return null;
    }

    @Override
    public Comment createComment(String data) {
        return null;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return null;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return null;
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        IDispatch r = (IDispatch)this.inode.invoke1("getElementsByTagName", (Object)tagname);
        if (r == null) {
            return null;
        }
        return new NodeListImpl(this, r);
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return null;
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public Element getElementById(String elementId) {
        IDispatch i = (IDispatch)this.inode.invoke1("getElementById", (Object)elementId);
        if (i == null) {
            return null;
        }
        return (Element)((Object)this.newNode(i, (short)1));
    }

    @Override
    public List<Node> getElementsByIdInAllFrames(String id) {
        List<Node> ids;
        ArrayList<Node> r = new ArrayList<Node>();
        Element e = this.getElementById(id);
        if (e != null) {
            r.add(e);
        }
        if ((ids = this.getElementsByIdInFrames(this.htmlDocument, id)) != null) {
            r.addAll(ids);
        }
        return r;
    }

    private List<Node> getElementsByIdInFrames(IDispatch htmlDocument, String id) {
        if (!this.hasFrames(htmlDocument)) {
            return null;
        }
        ArrayList<Node> r = new ArrayList<Node>();
        IOleContainer iole = (IOleContainer)htmlDocument.queryInterface(IUnknown.IID_IOleContainer);
        IEnumUnknown ieu = iole.enumObjects(1);
        if (ieu != null) {
            IUnknown[] iunks = ieu.next(1);
            while (iunks != null && iunks.length > 0) {
                try {
                    IDispatch d;
                    IDispatch idisp = (IDispatch)iunks[0].queryInterface(IUnknown.IID_IWebBrowser2);
                    if (idisp != null && (d = (IDispatch)Helper.get(idisp, "Document")) != null) {
                        NodeImpl n;
                        IDispatch in;
                        List<Node> r2 = this.getElementsByIdInFrames(d, id);
                        if (r2 != null) {
                            r.addAll(r2);
                        }
                        if ((in = (IDispatch)d.invoke1("getElementById", (Object)id)) != null && (n = this.newNode(in, (short)1)) != null) {
                            r.add(n);
                        }
                    }
                }
                catch (DispatchException dispatchException) {}
                iunks = ieu.next(1);
            }
        }
        return r;
    }

    private boolean hasFrames(IDispatch htmlDocument) {
        NodeListImpl nl;
        IDispatch r = (IDispatch)htmlDocument.invoke1("getElementsByTagName", (Object)"frame");
        if (r != null && (nl = new NodeListImpl(this, r)).getLength() > 0) {
            return true;
        }
        r = (IDispatch)htmlDocument.invoke1("getElementsByTagName", (Object)"iframe");
        return r != null && (nl = new NodeListImpl(this, r)).getLength() > 0;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return false;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Override
    public String getDocumentURI() {
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public Element getTargetElement(String target) {
        NodeList list = this.getElementsByTagName("A");
        int i = 0;
        while (i < list.getLength()) {
            Element el = (Element)list.item(i);
            if (target.equals(el.getAttribute("name"))) {
                return el;
            }
            ++i;
        }
        return this.getElementById(target);
    }

    public StyleSheetImpl createStyleSheet() {
        IDispatch r;
        block5: {
            block4: {
                try {
                    if (this.inode != null) break block4;
                    return null;
                }
                catch (DispatchException dispatchException) {
                    return null;
                }
            }
            r = (IDispatch)this.inode.invoke0("createStyleSheet");
            if (r != null) break block5;
            return null;
        }
        return new StyleSheetImpl(r);
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return HTMLElementFactory.createElement(this, this.inode, tagName);
    }

    @Override
    public String getCompatMode() {
        return (String)Helper.get(this.htmlDocument, "compatMode");
    }

    public IDispatch getWindow() {
        return (IDispatch)Helper.get(this.inode, "parentWindow");
    }

    public IDispatch getDocument() {
        return (IDispatch)Helper.get(this.inode, "documentElement");
    }
}

