/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util;

import java.io.File;
import java.io.IOException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public abstract class AbstractUIPluginACTF
extends AbstractUIPlugin {
    private File tmpDir = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.createTempDirectory();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.deleteFiles(this.tmpDir);
    }

    protected void createTempDirectory() {
        if (this.tmpDir == null) {
            String tmpS = String.valueOf(this.getStateLocation().toOSString()) + File.separator + "tmp";
            this.tmpDir = this.isAvailableDirectory(tmpS) ? new File(tmpS) : new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "ACTF");
        }
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        if (this.tmpDir == null) {
            this.createTempDirectory();
        }
        return File.createTempFile(prefix, suffix, this.tmpDir);
    }

    public File getTempDirectory() {
        if (this.tmpDir == null) {
            this.createTempDirectory();
        }
        return this.tmpDir;
    }

    private void deleteFiles(File rootDir) {
        if (rootDir != null) {
            File[] fileList = rootDir.listFiles();
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].isDirectory()) {
                    this.deleteFiles(fileList[i]);
                }
                fileList[i].delete();
                ++i;
            }
        }
    }

    private boolean isAvailableDirectory(String path) {
        File testDir = new File(path);
        return testDir.isDirectory() && testDir.canWrite() || testDir.mkdirs();
    }
}

