/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.errorhandler;

import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.html.parser.HTMLParser;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class InterleavedEndtagExchanger
implements IErrorHandler {
    public boolean handleError(int code, IParser parser, Node errorNode) throws ParseException, IOException, SAXException {
        if (code != 6 || !(errorNode instanceof EndTag)) {
            return false;
        }
        Node pNode = parser.getContext();
        while (pNode instanceof Element) {
            ElementDefinition ed;
            if (!pNode.getNodeName().equalsIgnoreCase(errorNode.getNodeName()) && !(ed = ((ISGMLParser)parser).getDTD().getElementDefinition(pNode.getNodeName())).endTagOmittable() && this.exchangeEndtag(parser, errorNode, ed.getName())) {
                return true;
            }
            pNode = pNode.getParentNode();
        }
        return false;
    }

    private boolean exchangeEndtag(IParser parser, Node errorNode, String target) throws ParseException, IOException, SAXException {
        Node[] foBuf = new Node[parser.getPushbackBufferSize() / 2];
        int i = 0;
        while (i < parser.getPushbackBufferSize() / 2) {
            Node fo = parser.getNode();
            if (fo instanceof EndTag && fo.getNodeName().equalsIgnoreCase(target)) {
                parser.error(6, errorNode + " and " + fo + " are interleaved. So exchange it by an error handler.");
                parser.pushBackNode(errorNode);
                while (i > 0) {
                    parser.pushBackNode(foBuf[--i]);
                }
                parser.pushBackNode(fo);
                return true;
            }
            foBuf[i] = fo;
            ++i;
        }
        while (i > 0) {
            parser.pushBackNode(foBuf[--i]);
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            HTMLParser parser = new HTMLParser();
            parser.addErrorLogListener(new IErrorLogListener(){

                public void errorLog(int code, String msg) {
                    System.err.println(msg);
                }
            });
            parser.setErrorHandler(new InterleavedEndtagExchanger());
            parser.parse(new FileInputStream(args[0]));
        }
        catch (Exception exception) {}
    }
}

