/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.io.impl;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import org.eclipse.actf.ai.audio.io.AudioIOException;
import org.eclipse.actf.ai.audio.io.IAudioWriter;

public class PlaybackDevice
implements IAudioWriter {
    private Mixer playbackMixer;
    private SourceDataLine playbackLine;
    private int limit;

    public boolean equals(Object o) {
        if (o instanceof PlaybackDevice) {
            return this.playbackMixer.equals(((PlaybackDevice)o).playbackMixer);
        }
        return false;
    }

    public PlaybackDevice(Mixer mixer) {
        this.playbackMixer = mixer;
    }

    public PlaybackDevice() {
        this.playbackMixer = null;
    }

    public String getName() {
        if (this.playbackMixer != null) {
            return "Device \"" + this.playbackMixer.getMixerInfo().getName() + "\"";
        }
        return "Device \"default\"";
    }

    public synchronized void close() {
        if (this.playbackLine != null) {
            this.playbackLine.drain();
            this.playbackLine.close();
        }
    }

    public boolean isClosed() {
        if (this.playbackLine == null) {
            return true;
        }
        return !this.playbackLine.isOpen();
    }

    public boolean canWrite() {
        return true;
    }

    public synchronized void open(AudioFormat format) throws AudioIOException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            this.playbackLine = this.playbackMixer != null ? (SourceDataLine)this.playbackMixer.getLine(info) : (SourceDataLine)AudioSystem.getLine(info);
            this.playbackLine.open();
            this.limit = this.playbackLine.available() / 10 * 5;
            this.playbackLine.start();
        }
        catch (LineUnavailableException e1) {
            e1.printStackTrace();
        }
    }

    public synchronized int write(byte[] data, int offset, int length) throws AudioIOException {
        if (this.playbackLine.available() > this.limit) {
            return this.playbackLine.write(data, offset, length);
        }
        return 0;
    }
}

