/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl;

import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.impl.AttrImpl;
import org.eclipse.actf.model.dom.dombycom.impl.DocumentImpl;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NamedNodeMapImpl;
import org.eclipse.actf.model.dom.dombycom.impl.NodeListNextSiblingImpl;
import org.eclipse.actf.model.dom.dombycom.impl.html.HTMLElementFactory;
import org.eclipse.actf.model.dom.dombycom.impl.object.ObjectElementFactory;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NodeImpl
implements Node {
    protected final IDispatch inode;
    protected final short nodeType;
    private NodeImpl parentNode;
    private DocumentImpl doc;
    String uniqueName;
    private String cachedNodeName = null;
    private NodeListNextSiblingImpl cachedChildNodes;

    IDispatch getIDispatch() {
        return this.inode;
    }

    private static String getUniqueName(IDispatch inode) {
        return (String)Helper.get(inode, "uniqueID");
    }

    private NodeImpl newNodeByType(IDispatch inode, short type) {
        switch (type) {
            case 2: {
                return new AttrImpl(this, inode);
            }
            case 9: {
                return this.doc;
            }
            case 4: 
            case 8: 
            case 10: {
                return new NodeImpl(this, inode, type);
            }
            case 1: {
                NodeImpl newNode;
                if (Helper.hasProperty(inode, "contentWindow")) {
                    return HTMLElementFactory.create(this, inode, "FrameNode");
                }
                String name = (String)Helper.get(inode, "nodeName");
                if (("OBJECT".equals(name) || "EMBED".equals(name)) && (newNode = ObjectElementFactory.create(this, inode)) != null) {
                    return newNode;
                }
                return HTMLElementFactory.create(this, inode, name);
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                return new NodeImpl(this, inode, type);
            }
            case 3: {
                return HTMLElementFactory.create(this, inode, "Text");
            }
        }
        return new NodeImpl(this, inode, type);
    }

    NodeImpl newNode(IDispatch inode) {
        NodeImpl anode;
        if (inode == null) {
            return null;
        }
        String uniqueName = NodeImpl.getUniqueName(inode);
        if (uniqueName != null && (anode = this.doc.lookupNode(uniqueName)) != null) {
            inode.release();
            return anode;
        }
        Integer val = (Integer)Helper.get(inode, "nodeType");
        if (val == null) {
            return null;
        }
        short type = (short)val.intValue();
        NodeImpl node = this.newNodeByType(inode, type);
        if (uniqueName != null) {
            node.uniqueName = uniqueName;
            this.doc.regNode(uniqueName, node);
        }
        return node;
    }

    protected NodeImpl newNode(IDispatch inode, short type) {
        if (inode == null) {
            return null;
        }
        String uniqueName = NodeImpl.getUniqueName(inode);
        if (uniqueName != null) {
            NodeImpl anode = this.doc.lookupNode(uniqueName);
            if (anode != null) {
                inode.release();
                return anode;
            }
            NodeImpl node = this.newNodeByType(inode, type);
            node.uniqueName = uniqueName;
            this.doc.regNode(uniqueName, node);
            return node;
        }
        return this.newNodeByType(inode, type);
    }

    protected NodeImpl newNode(IDispatch inode, short type, NodeImpl parent) {
        NodeImpl node = this.newNode(inode, type);
        node.parentNode = parent;
        return node;
    }

    public IDispatch getINode() {
        return this.inode;
    }

    NodeImpl(IDispatch inode) {
        this.doc = (DocumentImpl)this;
        this.inode = inode;
        this.nodeType = (short)9;
    }

    protected NodeImpl(NodeImpl baseNode, IDispatch inode, short nodeType) {
        this.doc = baseNode.doc;
        this.inode = inode;
        this.nodeType = nodeType;
    }

    public String getNodeName() {
        if (this.cachedNodeName == null) {
            this.cachedNodeName = (String)Helper.get(this.inode, "nodeName");
        }
        return this.cachedNodeName;
    }

    public String getNodeValue() throws DOMException {
        Object text = Helper.get(this.inode, "nodeValue");
        if (text == null) {
            return null;
        }
        if (text instanceof String) {
            return (String)text;
        }
        if (text instanceof IDispatch) {
            return (String)Helper.get((IDispatch)text, "data");
        }
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        Helper.put(this.inode, "nodeValue", nodeValue);
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public Node getParentNode() {
        if (this.parentNode == null) {
            IDispatch parent = (IDispatch)Helper.get(this.inode, "parentNode");
            this.parentNode = this.newNode(parent);
        }
        return this.parentNode;
    }

    public NodeList getChildNodes() {
        if (this.cachedChildNodes != null) {
            this.cachedChildNodes.initialize();
        } else {
            this.cachedChildNodes = new NodeListNextSiblingImpl(this);
        }
        return this.cachedChildNodes;
    }

    public Node getFirstChild() {
        IDispatch firstChild = (IDispatch)Helper.get(this.inode, "firstChild");
        return this.newNode(firstChild);
    }

    public Node getLastChild() {
        IDispatch lastChild = (IDispatch)Helper.get(this.inode, "lastChild");
        return this.newNode(lastChild);
    }

    public Node getPreviousSibling() {
        IDispatch previousSibling = (IDispatch)Helper.get(this.inode, "previousSibling");
        return this.newNode(previousSibling);
    }

    public Node getNextSibling() {
        IDispatch nextSibling = (IDispatch)Helper.get(this.inode, "nextSibling");
        return this.newNode(nextSibling);
    }

    public NamedNodeMap getAttributes() {
        IDispatch attributes = (IDispatch)Helper.get(this.inode, "attributes");
        if (attributes == null) {
            return null;
        }
        return new NamedNodeMapImpl(this, attributes);
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (!(newChild instanceof NodeImpl) || !(refChild instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl nci = (NodeImpl)newChild;
        NodeImpl rci = (NodeImpl)refChild;
        IDispatch i = (IDispatch)this.inode.invoke("insertBefore", new Object[]{nci.getINode(), rci.getINode()});
        return this.newNode(i);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (!(newChild instanceof NodeImpl) || !(oldChild instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl nci = (NodeImpl)newChild;
        NodeImpl oci = (NodeImpl)oldChild;
        IDispatch i = (IDispatch)this.inode.invoke("replaceChild", new Object[]{nci.getINode(), oci.getINode()});
        return this.newNode(i);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        if (!(oldChild instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl oci = (NodeImpl)oldChild;
        IDispatch i = (IDispatch)this.inode.invoke1("removeChild", (Object)oci.getINode());
        return this.newNode(i);
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (!(newChild instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl nci = (NodeImpl)newChild;
        IDispatch i = (IDispatch)this.inode.invoke1("appendChild", (Object)nci.getINode());
        return this.newNode(i);
    }

    public boolean hasChildNodes() {
        Boolean b = (Boolean)this.inode.invoke0("hasChildNodes");
        if (b == null) {
            return false;
        }
        return b;
    }

    public Node cloneNode(boolean deep) {
        IDispatch i = (IDispatch)this.inode.invoke1("cloneNode", (Object)deep);
        return this.newNode(i);
    }

    public void normalize() {
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String getNamespaceURI() {
        String r = (String)Helper.get(this.inode, "namespaceURI");
        if (r == null) {
            return "";
        }
        if (r.length() == 0) {
            return "";
        }
        return r;
    }

    public String getPrefix() {
        String r = this.getNodeName();
        if (r == null) {
            return "";
        }
        int pos = r.indexOf(":");
        if (pos < 0) {
            return "";
        }
        return r.substring(0, pos);
    }

    public void setPrefix(String prefix) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        String r = this.getNodeName();
        if (r == null) {
            return "";
        }
        int pos = r.indexOf(":");
        if (pos < 0) {
            return r;
        }
        return r.substring(pos + 1);
    }

    public boolean hasAttributes() {
        IDispatch attributes = (IDispatch)Helper.get(this.inode, "attributes");
        return attributes != null;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException();
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean isSameNode(Node other) {
        return this == other;
    }

    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException();
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    public Object getUserData(String key) {
        throw new UnsupportedOperationException();
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    public String getLinkURI() {
        String uri = (String)Helper.get(this.inode, "href");
        if (uri == null) {
            Node p = this.getParentNode();
            if (p instanceof INodeEx) {
                return ((INodeEx)p).getLinkURI();
            }
            return null;
        }
        return uri;
    }

    public short getHeadingLevel() {
        Node parent = this.getParentNode();
        if (parent instanceof INodeEx) {
            return ((INodeEx)parent).getHeadingLevel();
        }
        return 0;
    }

    public AnalyzedResult analyze(AnalyzedResult ar) {
        if (!Vocabulary.isValidNode().eval((IEvalTarget)this)) {
            return ar;
        }
        Node n = this.getFirstChild();
        while (n != null) {
            if (n instanceof INodeEx) {
                ar = ((INodeEx)n).analyze(ar);
            }
            n = n.getNextSibling();
        }
        return ar;
    }

    public void setText(String text) {
        if (Helper.hasProperty(this.inode, "value")) {
            Helper.put(this.inode, "value", text);
        } else {
            NodeImpl element = (NodeImpl)this.getParentNode();
            if ("TEXTAREA".equals(element.getLocalName())) {
                IDispatch tr = (IDispatch)element.inode.invoke0("createTextRange");
                Helper.put(tr, "text", text);
            }
        }
    }

    public String getText() {
        String ret = "";
        if (Helper.hasProperty(this.inode, "value")) {
            Object obj = Helper.get(this.inode, "value");
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj != null) {
                return obj.toString();
            }
        } else {
            NodeImpl element = (NodeImpl)this.getParentNode();
            if ("TEXTAREA".equals(element.getLocalName())) {
                IDispatch tr = (IDispatch)element.inode.invoke0("createTextRange");
                ret = (String)Helper.get(tr, "text");
            }
        }
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public int getNth() {
        IDispatch current = this.inode;
        int i = 1;
        while (current != null) {
            current = (IDispatch)Helper.get(current, "previousSibling");
            ++i;
        }
        return i;
    }

    public String getUniqueID() {
        return (String)Helper.get(this.inode, "uniqueID");
    }

    public String[] getStillPictureData() {
        String[] ret = new String[3];
        ret[1] = (String)Helper.get(this.inode, "src");
        ret[2] = "";
        String mt = (String)Helper.get(this.inode, "mimeType");
        ret[0] = mt == null ? "" : ((mt = mt.toUpperCase()).contains("GIF") ? "image/gif" : (mt.contains("JPEG") ? "image/jpeg" : (mt.contains("PNG") ? "image/png" : "")));
        return ret;
    }
}

