/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.object;

import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.MediaObjectImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;

class WMP64NodeImpl
extends MediaObjectImpl {
    private boolean muteState;

    WMP64NodeImpl(NodeImpl baseNode, IDispatch idisp) {
        super(baseNode, idisp);
    }

    private boolean execControls(String cmd) {
        try {
            this.inode.invoke0(cmd);
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    private boolean putSettings(String prop, Object val) {
        try {
            this.inode.put(prop, val);
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    private Object getSettings(String prop) {
        return Helper.get(this.inode, prop);
    }

    public boolean fastForward() {
        return this.execControls("fastForward");
    }

    public boolean fastReverse() {
        return this.execControls("fastReverse");
    }

    public double getCurrentPosition() {
        Object o = Helper.get(this.inode, "currentPosition");
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return 0.0;
    }

    public double getTotalLength() {
        return -1.0;
    }

    public boolean nextTrack() {
        return this.execControls("next");
    }

    public boolean pauseMedia() {
        return this.execControls("pause");
    }

    public boolean playMedia() {
        return this.execControls("play");
    }

    public boolean previousTrack() {
        return this.execControls("previous");
    }

    public boolean stopMedia() {
        return this.execControls("stop");
    }

    public int getVolume() {
        Object o = this.getSettings("Volume");
        if (!(o instanceof Integer)) {
            return -1;
        }
        int vol = (Integer)o;
        if (vol < -2000) {
            return 0;
        }
        return (vol + 2000) * 1000 / 2000 + 0;
    }

    public boolean muteMedia(boolean flag) {
        if (this.putSettings("Mute", flag)) {
            this.muteState = flag;
            return true;
        }
        return false;
    }

    public boolean getMuteState() {
        Object o = this.getSettings("Mute");
        if (!(o instanceof Boolean)) {
            return false;
        }
        return (Boolean)o != false || this.muteState;
    }

    public boolean setVolume(int val) {
        val = (val = (val - 0) * 2000 / 1000) == 0 ? -10000 : (val -= 2000);
        return this.putSettings("Volume", val);
    }

    public INodeExVideo.VideoState getCurrentState() {
        Object o = Helper.get(this.inode, "PlayState");
        if (o instanceof Integer) {
            int wmpst = (Integer)o;
            switch (wmpst) {
                case 0: {
                    return INodeExVideo.VideoState.STATE_STOP;
                }
                case 1: {
                    return INodeExVideo.VideoState.STATE_PAUSE;
                }
                case 2: {
                    return INodeExVideo.VideoState.STATE_PLAY;
                }
                case 3: {
                    return INodeExVideo.VideoState.STATE_WAITING;
                }
                case 4: 
                case 6: {
                    return INodeExVideo.VideoState.STATE_FASTFORWARD;
                }
                case 5: 
                case 7: {
                    return INodeExVideo.VideoState.STATE_FASTREVERSE;
                }
            }
            return INodeExVideo.VideoState.STATE_STOP;
        }
        return INodeExVideo.VideoState.STATE_UNKNOWN;
    }
}

