/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.Arrays;
import java.util.List;
import org.eclipse.actf.ai.fennec.FennecException;
import org.eclipse.actf.ai.fennec.impl.FennecBundleMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMode;
import org.eclipse.actf.ai.fennec.impl.FennecRecombinantMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecServiceImpl;
import org.eclipse.actf.ai.fennec.impl.TreeItemFennec;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.w3c.dom.Node;

class FennecGeneratedMetadata
extends FennecBundleMetadata {
    private final Node node;

    public String getAltText(ITreeItem item) {
        String r = super.getAltText(item);
        if (r == null) {
            return null;
        }
        if (r.length() > 0) {
            return r;
        }
        if (this.node instanceof INodeEx) {
            return ((INodeEx)this.node).extractString();
        }
        return "";
    }

    public String getDescription(ITreeItem item) {
        return super.getDescription(item);
    }

    public short getHeadingLevelByMetadata(ITreeItem item) {
        return super.getHeadingLevel(item);
    }

    public short getHeadingLevel(ITreeItem item) {
        short r = super.getHeadingLevel(item);
        if (r > 0) {
            return r;
        }
        if (r == -1) {
            return -1;
        }
        if (this.node instanceof INodeEx) {
            return ((INodeEx)this.node).getHeadingLevel();
        }
        return 0;
    }

    List expand(TreeItemFennec pItem, int trigger) throws FennecException {
        ITreeItem[] childItems = pItem.getChildItems();
        if (!this.mode.changed(pItem, trigger) && pItem.hasAlreadyChildRefreshed()) {
            return Arrays.asList(childItems);
        }
        TreeItemFennec bItem = this.mode.buildItemContinued(this.node, pItem);
        if (bItem != null && bItem.hasChild()) {
            return Arrays.asList(bItem.getChildItems());
        }
        return null;
    }

    public static FennecGeneratedMetadata generate(FennecRecombinantMetadata metadata, FennecMode mode, Node node, FennecMetadata[] childMds) {
        return new FennecGeneratedMetadata(metadata.fennecService, mode, node, childMds);
    }

    private FennecGeneratedMetadata(FennecServiceImpl fennecService, FennecMode mode, Node node, FennecMetadata[] childMds) {
        super(fennecService, mode, node, childMds);
        this.node = node;
    }

    public static FennecMetadata generate(FennecGeneratedMetadata meta, FennecGeneratedMetadata meta2) {
        FennecMetadata[] childMds = new FennecMetadata[meta.childMetadata.length + meta2.childMetadata.length];
        int i = 0;
        while (i < meta.childMetadata.length) {
            childMds[i] = meta.childMetadata[i];
            ++i;
        }
        i = 0;
        while (i < meta2.childMetadata.length) {
            childMds[meta.childMetadata.length + i] = meta2.childMetadata[i];
            ++i;
        }
        return new FennecGeneratedMetadata(meta.fennecService, meta.mode, meta.node, childMds);
    }
}

