/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.local;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.IXMLStore;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.eclipse.actf.ai.xmlstore.local.SubStore;
import org.eclipse.actf.ai.xmlstore.local.XMLFile;
import org.eclipse.actf.ai.xmlstore.local.XMLFileListStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStoreLocal
extends XMLFileListStore {
    public static final String SYSTEM_DIR_NAME = "system";
    private final File directory;
    private final String[] extensions;

    protected void register(File file) {
        try {
            XMLFile xf = new XMLFile(file);
            this.list.add(xf);
        }
        catch (XMLStoreException xMLStoreException) {}
    }

    protected void registerDir(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] fileList = dir.listFiles();
        int i = 0;
        while (i < fileList.length) {
            File f = fileList[i];
            if (f.isDirectory()) {
                this.registerDir(f);
            } else if (this.isNotTemporal(f) && this.matchExtension(f)) {
                this.register(f);
            }
            ++i;
        }
    }

    protected boolean matchExtension(File f) {
        String name = f.getName();
        boolean result = false;
        int i = 0;
        while (i < this.extensions.length) {
            result = result || name.endsWith(this.extensions[i]);
            ++i;
        }
        return result;
    }

    protected boolean isNotTemporal(File f) {
        String name = f.getName();
        if (name.startsWith("#") && name.endsWith("#")) {
            return false;
        }
        return !name.endsWith("~");
    }

    private void init() {
        this.list = new ArrayList();
        this.registerDir(this.directory);
    }

    @Override
    public Iterator<IXMLInfo> getInfoIterator() {
        return new SubStore.InfoIterator(this.list);
    }

    @Override
    public IXMLStore specify(IXMLSelector selector) {
        return new SubStore(this, selector);
    }

    @Override
    public void refleshAll() {
        this.init();
    }

    public XMLStoreLocal(File directory, String[] extensions) {
        this.directory = directory;
        this.extensions = extensions;
        this.init();
    }

    public static XMLFile newXMLFile(File file) throws XMLStoreException {
        return new XMLFile(file);
    }
}

