/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.actf.ai.xmlstore.nvdl.NVDLException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLElement;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLMessage;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLMode;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModel;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NVDLAction
extends NVDLModel {
    private String useModeName;
    private NVDLMode useMode;
    private List<Context> contexts = new ArrayList<Context>();
    private final String name;
    private NVDLMessage message;
    private NVDLRule belongingRule;

    public String getName() {
        return this.name;
    }

    public String getUseModeName() {
        return this.useModeName;
    }

    public List<Context> getContextsList() {
        return this.contexts;
    }

    public NVDLMode getUseMode() {
        return this.useMode;
    }

    public void setUseMode(NVDLMode useMode) {
        this.useMode = useMode;
        this.useModeName = useMode.name;
    }

    public NVDLMessage getMessage() {
        if (this.message == null) {
            this.message = new NVDLMessage();
        }
        return this.message;
    }

    public NVDLRule getBelongingRule() {
        return this.belongingRule;
    }

    public void addContext(String path, String useModeName) throws NVDLException {
        this.contexts.add(new Context(path, useModeName, null));
    }

    public void addContext(String path, NVDLMode useMode) throws NVDLException {
        this.contexts.add(new Context(path, useMode.name, useMode));
    }

    public NVDLMode nextMode(LinkedList elemStack) {
        int size = this.contexts.size();
        int i = 0;
        while (i < size) {
            Context c = this.contexts.get(i);
            if (c.match(elemStack)) {
                return c.useMode;
            }
            ++i;
        }
        return this.useMode;
    }

    NVDLAction(String name, String useModeName, NVDLRule belongingRule) {
        this.name = name;
        this.useModeName = useModeName;
        this.belongingRule = belongingRule;
    }

    public static class Context {
        public final String path;
        public final Path[] pathExps;
        public final String useModeName;
        public NVDLMode useMode;

        public boolean match(LinkedList elemStack) {
            int i = 0;
            while (i < this.pathExps.length) {
                int sectionIdx = -1;
                ListIterator it = elemStack.listIterator(elemStack.size());
                Path p = this.pathExps[i];
                int j = p.pathElems.length - 1;
                while (true) {
                    if (!it.hasPrevious()) {
                        if (j >= 0) break;
                        return true;
                    }
                    NVDLElement e = (NVDLElement)it.previous();
                    if (sectionIdx < 0) {
                        sectionIdx = e.sectionIdx;
                    } else if (e.sectionIdx != sectionIdx) {
                        if (j >= 0) break;
                        return true;
                    }
                    if (j < 0) {
                        if (p.isAbsolute) break;
                        return true;
                    }
                    if (!p.pathElems[j].equals(e.localName)) break;
                    --j;
                }
                ++i;
            }
            return false;
        }

        public boolean match(NVDLElement e) {
            int i = 0;
            while (i < this.pathExps.length) {
                Path p = this.pathExps[i];
                int j = p.pathElems.length - 1;
                while (true) {
                    if (j < 0) {
                        if (p.isAbsolute) break;
                        return true;
                    }
                    if (!p.pathElems[j].equals(e.localName)) break;
                    if (e.isSectionHead()) {
                        if (j > 0) break;
                        return true;
                    }
                    e = e.parent;
                    --j;
                }
                ++i;
            }
            return false;
        }

        private int extractPathElement(int i, String path, StringBuffer ret) {
            boolean startPath = false;
            boolean slashAppeared = false;
            boolean endPath = false;
            ret.delete(0, ret.length());
            while (i < path.length()) {
                switch (path.charAt(i)) {
                    case '|': {
                        return i;
                    }
                    case '/': {
                        if (startPath) {
                            return i;
                        }
                        if (slashAppeared) {
                            return -1;
                        }
                        slashAppeared = true;
                        ret.append(path.charAt(i++));
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (startPath) {
                            endPath = true;
                        }
                        ++i;
                        break;
                    }
                    default: {
                        if (endPath) {
                            return -1;
                        }
                        startPath = true;
                        ret.append(path.charAt(i++));
                    }
                }
            }
            return i;
        }

        private void invalidPath(String path) throws NVDLException {
            throw new NVDLException("Invalid Path:" + path);
        }

        private Path[] parsePath(String path) throws NVDLException {
            StringBuffer buf = new StringBuffer();
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList<Path> pathExps = new ArrayList<Path>();
            boolean isAbsolute = false;
            int len = path.length();
            int i = 0;
            while (i < len) {
                int pathElems;
                block13: {
                    paths.clear();
                    i = this.extractPathElement(i, path, buf);
                    if (i < 0) {
                        this.invalidPath(path);
                    }
                    if (i < len && path.charAt(i) == '|') {
                        this.invalidPath(path);
                    }
                    if (buf.charAt(0) == '/') {
                        isAbsolute = true;
                        paths.add(buf.substring(1, buf.length()));
                    } else {
                        isAbsolute = false;
                        if (buf.length() == 0) {
                            this.invalidPath(path);
                        }
                        paths.add(buf.toString());
                    }
                    if (i < len) {
                        do {
                            if ((i = this.extractPathElement(i, path, buf)) < 0) {
                                this.invalidPath(path);
                            }
                            if (buf.charAt(0) == '/') {
                                if (buf.length() == 1) {
                                    this.invalidPath(path);
                                }
                                paths.add(buf.substring(1, buf.length()));
                            } else {
                                paths.add(buf.toString());
                            }
                            if (i >= len) break block13;
                        } while (path.charAt(i) != '|');
                        ++i;
                    }
                }
                if ((pathElems = paths.size()) == 0) {
                    this.invalidPath(path);
                }
                Path cpath = new Path(paths.toArray(new String[pathElems]), isAbsolute);
                pathExps.add(cpath);
            }
            return pathExps.toArray(new Path[pathExps.size()]);
        }

        Context(String path, String useModeName, NVDLMode useMode) throws NVDLException {
            this.path = path;
            this.pathExps = this.parsePath(path);
            this.useModeName = useModeName;
            this.useMode = useMode;
        }

        static class Path {
            final String[] pathElems;
            final boolean isAbsolute;

            Path(String[] pathElems, boolean isAbsolute) {
                this.pathElems = pathElems;
                this.isAbsolute = isAbsolute;
            }
        }
    }
}

