/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.reader;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.SchemaFactory;
import org.eclipse.actf.ai.xmlstore.nvdl.NVDLException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.Location;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAllowAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLMessage;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLMode;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModel;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRejectAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRule;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLValidateAction;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.NVDLReaderException;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.NVDLSimplifier;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.SchemaLoader;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.SchemaReaderProxy;
import org.eclipse.actf.ai.xmlstore.nvdl.util.DefaultErrorHandler;
import org.eclipse.actf.ai.xmlstore.nvdl.util.Log;
import org.eclipse.actf.ai.xmlstore.nvdl.util.PrefixMapper;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class NVDLSAXReader {
    private NVDLRules rules;
    private ErrorHandler eh;
    private Locator locator;
    private int errorCounter;
    private XMLReader reader;
    private static final String NSNAME = "xmlns";
    private PrefixMapper prefixMapper = new PrefixMapper();

    private Location newLocation() {
        return new Location(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
    }

    private void setLocation(NVDLModel m) {
        m.setLocation(this.newLocation());
    }

    private void error(NVDLReaderException e) throws SAXException {
        if (this.eh != null) {
            this.eh.error(new SAXParseException(e.getMessage(), this.locator, e));
        }
    }

    private void readUnknownError(String mes, Object[] args) throws SAXException {
        ++this.errorCounter;
        this.error(new NVDLReaderException(mes, args));
    }

    private void readInvalidError(String mes) throws SAXException {
        this.readInvalidError(mes, new Object[0]);
    }

    private void readInvalidError(String mes, Object[] args) throws SAXException {
        ++this.errorCounter;
        this.error(new NVDLReaderException(mes, args));
    }

    private boolean isForeign(String iri) {
        return !"http://purl.oclc.org/dsdl/nvdl/ns/structure/1.0".equals(iri);
    }

    private boolean isLocal(String iri) {
        return iri.length() == 0;
    }

    private boolean isNSDecl(String qName) {
        if (!qName.startsWith(NSNAME)) {
            return false;
        }
        if (qName.length() == NSNAME.length()) {
            return true;
        }
        return qName.charAt(NSNAME.length()) == ':';
    }

    private void setHandler(BaseHandler h) {
        this.reader.setContentHandler(h);
    }

    private StringBuffer removeLeadingAndTrailingSpaces(StringBuffer sb) {
        char c;
        int len = sb.length();
        int s = 0;
        block6: while (s < len) {
            c = sb.charAt(s);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    break block6;
                }
            }
            ++s;
        }
        if (s == len - 1) {
            sb.delete(0, s);
            return sb;
        }
        int e = len - 1;
        block7: while (s >= 0) {
            c = sb.charAt(e);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    break block7;
                }
            }
            --s;
        }
        if (s > 0) {
            sb.delete(0, s);
        }
        if (e < len - 1) {
            sb.delete(e, len - 1);
        }
        return sb;
    }

    private String[] splitList(String s) {
        return s.split("[ \r\n\t]");
    }

    private boolean checkWhiteSpace(char[] ch, int start, int length) {
        int i = 0;
        while (i < length) {
            switch (ch[start + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean parseXSDBoolean(String s, boolean defaultValue) throws SAXException {
        if (s == null) {
            return defaultValue;
        }
        StringBuffer sb = this.removeLeadingAndTrailingSpaces(new StringBuffer(s));
        String s2 = sb.toString();
        if (s2.equals("0")) {
            return false;
        }
        if (s2.equals("false")) {
            return false;
        }
        if (s2.equals("1")) {
            return true;
        }
        if (s2.equals("true")) {
            return true;
        }
        this.readInvalidError("NVDLReader.XSDBooleanError", new Object[]{s});
        return false;
    }

    private void getAttrs(Attributes attr, AtRet[] ars) throws SAXException {
        int len = attr.getLength();
        int i = 0;
        while (i < len) {
            String iri = attr.getURI(i);
            if (this.isLocal(iri)) {
                String localName = attr.getLocalName(i);
                String qName = attr.getQName(i);
                if (!this.isNSDecl(qName)) {
                    int j = 0;
                    while (true) {
                        if (j >= ars.length) {
                            this.readUnknownError("NVDLReader.UnallowedAttributeError", new Object[]{localName});
                        }
                        if (ars[j].name.equals(localName)) {
                            ars[j].value = attr.getValue(i);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void checkAttrs(Attributes attr) throws SAXException {
        int len = attr.getLength();
        int i = 0;
        while (i < len) {
            String iri = attr.getURI(i);
            String localName = attr.getLocalName(i);
            if (this.isLocal(iri)) {
                this.readUnknownError("NVDLReader.UnallowedAttributeError", new Object[]{localName});
            }
            ++i;
        }
    }

    private String getXMLID(Attributes attrs) throws SAXException {
        return attrs.getValue("id");
    }

    private void addRule(NVDLMode mode, NVDLRule rule) throws SAXException {
        NVDLRule conflictedRule = mode.addRule(rule);
        if (conflictedRule != null) {
            this.readInvalidError("NVDLReader.RuleConflictsError", new Object[]{rule.toString(), conflictedRule.toString()});
        }
    }

    private void checkNestedMode(NVDLAction action) throws SAXException {
        if (action.getUseModeName() != null) {
            this.readInvalidError("NVDLReader.NestedModeAndUseModeError");
        }
        if (action.getUseMode() != null) {
            this.readInvalidError("NVDLReader.DuplicatedNestedModeError");
        }
    }

    private String uniqueModeName() {
        String fname;
        StringBuffer name = new StringBuffer("mode-");
        name.append(this.locator.getLineNumber());
        name.append("-");
        name.append(this.locator.getColumnNumber());
        name.append("-");
        int i = 1;
        while (this.rules.getMode(fname = String.valueOf(name.toString()) + i) != null) {
            ++i;
        }
        return fname;
    }

    private String uniqueActionID(Attributes attrs) throws SAXException {
        String id = this.getXMLID(attrs);
        if (id == null || id.length() == 0) {
            int i = 1;
            while (this.rules.getAction(id = "A" + i) != null) {
                ++i;
            }
        }
        return id;
    }

    private void parseRuleActions(BaseHandler bh, NVDLRule rule) {
        this.setHandler(new ActionsHandler(bh, rule));
    }

    private SchemaLoader newSchemaLoader(String schemaType) {
        return new SchemaLoader(this.locator.getSystemId(), this.newLocation());
    }

    private void parseMessage(BaseHandler bh, NVDLMessage nm, Attributes attrs) {
        String lang = attrs.getValue("xml:lang");
        this.setHandler(new MessageHandler(bh, nm, lang));
    }

    private void parseSchema(BaseHandler bh, NVDLValidateAction action, Attributes attrs) throws SAXException {
        this.checkAttrs(attrs);
        this.setHandler(new SchemaHandler(bh, action));
    }

    private void parseContext(BaseHandler bh, NVDLAction action, Attributes attrs) throws SAXException {
        AtRet[] ars = new AtRet[]{new AtRet("path"), new AtRet("useMode")};
        this.getAttrs(attrs, ars);
        if (ars[0].value == null) {
            this.readInvalidError("NVDLReader.ContextHasPathError");
        }
        this.setHandler(new ContextHandler(bh, action, ars[0].value, ars[1].value));
    }

    private NVDLMode parseMode(BaseHandler ph, Attributes attrs) throws SAXException {
        AtRet[] ars = new AtRet[]{new AtRet("name")};
        this.getAttrs(attrs, ars);
        if (ars[0].value == null) {
            this.readInvalidError("NVDLReader.ModeInRulesHasName");
        }
        NVDLMode mode = new NVDLMode(ars[0].value);
        this.setLocation(mode);
        if (this.rules.getMode(mode.name) != null) {
            this.readInvalidError("NVDLReader.ModeNameConflictError", new Object[]{mode.name});
        }
        this.setHandler(new ModeHandler(ph, mode));
        this.rules.putMode(mode);
        return mode;
    }

    private NVDLMode parseIncludedMode(BaseHandler ph, Attributes attrs, NVDLMode parentMode) throws SAXException {
        AtRet[] ars = new AtRet[]{new AtRet("name")};
        this.getAttrs(attrs, ars);
        NVDLMode mode = new NVDLMode(ars[0].value);
        this.setLocation(mode);
        this.setHandler(new ModeHandler(ph, mode));
        parentMode.addIncludedMode(mode);
        return mode;
    }

    private NVDLMode parseNestedMode(BaseHandler ph, Attributes attrs) throws SAXException {
        this.checkAttrs(attrs);
        NVDLMode mode = new NVDLMode(this.uniqueModeName());
        this.setLocation(mode);
        this.setHandler(new ModeHandler(ph, mode));
        return mode;
    }

    public NVDLRules parse(InputSource is) throws NVDLReaderException, IOException {
        block7: {
            this.errorCounter = 0;
            try {
                this.reader.parse(is);
                if (this.errorCounter <= 0) break block7;
                this.readInvalidError("NVDLReader.NVDLHasError", new Object[]{new Integer(this.errorCounter)});
                return null;
            }
            catch (SAXException e) {
                Exception ei = e.getException();
                if (ei instanceof NVDLReaderException) {
                    throw (NVDLReaderException)ei;
                }
                throw new NVDLReaderException(e);
            }
        }
        NVDLSimplifier simplifier = new NVDLSimplifier(this.rules, this.eh);
        try {
            simplifier.traverse(this.rules);
        }
        catch (NVDLModelException e) {
            throw new NVDLReaderException(e);
        }
        if (simplifier.getErrorCount() > 0) {
            this.readInvalidError("NVDLReader.NVDLHasError", new Object[]{new Integer(simplifier.getErrorCount())});
            return null;
        }
        return this.rules;
    }

    public static SAXParser newSAXParser() throws SAXException {
        SAXParserFactory pf = SAXParserFactory.newInstance();
        try {
            pf.setFeature("http://xml.org/sax/features/namespaces", true);
            pf.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            pf.setXIncludeAware(true);
            return pf.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public NVDLSAXReader(SAXParser parser) throws SAXException {
        this(parser, null);
    }

    public NVDLSAXReader(ErrorHandler eh) throws SAXException {
        this(NVDLSAXReader.newSAXParser(), eh);
    }

    public NVDLSAXReader(SAXParser parser, ErrorHandler eh) throws SAXException {
        this.reader = parser.getXMLReader();
        this.eh = eh != null ? eh : DefaultErrorHandler.getErrorHandler();
        this.setHandler(new InitialHandler());
    }

    private class ActionBaseHandler
    extends WSSkipHandler {
        private final NVDLAction action;
        protected static final int INITIAL = 0;
        protected static final int MESSAGE_OPTION_APPEARED = 1;
        protected static final int SCHEMA_APPEARED = 2;
        protected static final int MODEUSAGE1_APPEARED = 3;
        protected static final int CONTEXT_APPEARED = 4;
        protected int actionBaseState;

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (NVDLSAXReader.this.isForeign(uri)) {
                NVDLSAXReader.this.setHandler(new ForeignSkipHandler(this));
                return;
            }
            if (localName.equals("message")) {
                if (this.actionBaseState > 1) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.MessageBeforeSchemaError");
                }
                this.actionBaseState = 1;
                NVDLSAXReader.this.parseMessage(this, this.action.getMessage(), attrs);
            } else if (localName.equals("mode")) {
                NVDLSAXReader.this.checkNestedMode(this.action);
                if (this.actionBaseState > 3) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.ModeBeforeContextError");
                }
                this.actionBaseState = 3;
                this.action.setUseMode(NVDLSAXReader.this.parseNestedMode(this, attrs));
            } else if (localName.equals("context")) {
                this.actionBaseState = 4;
                NVDLSAXReader.this.parseContext(this, this.action, attrs);
            } else {
                super.startElement(uri, localName, qName, attrs);
            }
        }

        ActionBaseHandler(BaseHandler bh, NVDLAction action) {
            super(bh);
            this.actionBaseState = 0;
            this.action = action;
        }
    }

    private class ActionsHandler
    extends WSSkipHandler {
        private final NVDLRule baseRule;
        private boolean cancelNestedActions;
        private boolean noResultAction;
        private boolean resultAction;

        private void checkResultAction(String localName) throws SAXException {
            if (this.resultAction) {
                NVDLSAXReader.this.readInvalidError("NVDLReader.OneResultActionError", new Object[]{localName});
            }
        }

        private void parseValidate(Attributes attrs) throws SAXException {
            AtRet[] ars = new AtRet[]{new AtRet("useMode"), new AtRet("message"), new AtRet("schemaType"), new AtRet("schema"), new AtRet("id")};
            NVDLSAXReader.this.getAttrs(attrs, ars);
            String id = NVDLSAXReader.this.uniqueActionID(attrs);
            NVDLValidateAction action = new NVDLValidateAction(id, ars[0].value, this.baseRule);
            NVDLSAXReader.this.rules.putAction(action);
            NVDLSAXReader.this.setLocation(action);
            this.baseRule.getActionManager().addNoResultAction(action);
            if (ars[2].value != null) {
                action.setSchemaType(ars[2].value);
            }
            if (ars[3].value != null) {
                action.setSchemaIRI(ars[3].value);
            }
            if (ars[1].value != null) {
                action.getMessage().addMessage(null, ars[2].value);
            }
            action.setSchemaLoader(NVDLSAXReader.this.newSchemaLoader(action.getSchemaType()));
            NVDLSAXReader.this.setHandler(new ValidateHandler((BaseHandler)this, action));
        }

        private AtRet[] parseBaseActionAttributes(Attributes attrs) throws SAXException {
            AtRet[] ars = new AtRet[]{new AtRet("useMode"), new AtRet("message"), new AtRet("id")};
            NVDLSAXReader.this.getAttrs(attrs, ars);
            return ars;
        }

        private void parseActionBase(NVDLAction action, String message) {
            NVDLSAXReader.this.rules.putAction(action);
            NVDLSAXReader.this.setLocation(action);
            if (message != null) {
                action.getMessage().addMessage(null, message);
            }
            NVDLSAXReader.this.setHandler(new ActionBaseHandler(this, action));
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (NVDLSAXReader.this.isForeign(uri)) {
                NVDLSAXReader.this.setHandler(new ForeignSkipHandler(this));
                return;
            }
            if (this.cancelNestedActions) {
                NVDLSAXReader.this.readInvalidError("NVDLReader.CancelNestedActionsError", new Object[]{localName});
            }
            if (localName.equals("cancelNestedActions")) {
                this.cancelNestedActions = true;
                NVDLSAXReader.this.checkAttrs(attrs);
                this.baseRule.getActionManager().setCancelAction();
                NVDLSAXReader.this.setHandler(new WSSkipHandler(this));
            } else if (localName.equals("validate")) {
                this.noResultAction = true;
                this.parseValidate(attrs);
            } else if (localName.equals("allow")) {
                this.noResultAction = true;
                AtRet[] atr = this.parseBaseActionAttributes(attrs);
                String id = NVDLSAXReader.this.uniqueActionID(attrs);
                NVDLAllowAction a = new NVDLAllowAction(id, atr[0].value, this.baseRule);
                this.baseRule.getActionManager().addNoResultAction(a);
                this.parseActionBase(a, atr[1].value);
            } else if (localName.equals("reject")) {
                this.noResultAction = true;
                AtRet[] atr = this.parseBaseActionAttributes(attrs);
                String id = NVDLSAXReader.this.uniqueActionID(attrs);
                NVDLRejectAction a = new NVDLRejectAction(id, atr[0].value, this.baseRule);
                this.baseRule.getActionManager().addNoResultAction(a);
                this.parseActionBase(a, atr[1].value);
            } else if (localName.equals("attach")) {
                this.checkResultAction(localName);
                this.resultAction = true;
                AtRet[] atr = this.parseBaseActionAttributes(attrs);
                String id = NVDLSAXReader.this.uniqueActionID(attrs);
                NVDLResultAction a = new NVDLResultAction(id, atr[0].value, 1, this.baseRule);
                this.baseRule.getActionManager().setResultAction(a);
                this.parseActionBase(a, atr[1].value);
            } else if (localName.equals("attachPlaceHolder")) {
                this.checkResultAction(localName);
                this.resultAction = true;
                AtRet[] atr = this.parseBaseActionAttributes(attrs);
                String id = NVDLSAXReader.this.uniqueActionID(attrs);
                NVDLResultAction a = new NVDLResultAction(id, atr[0].value, 2, this.baseRule);
                this.baseRule.getActionManager().setResultAction(a);
                this.parseActionBase(a, atr[1].value);
            } else if (localName.equals("unwrap")) {
                this.checkResultAction(localName);
                this.resultAction = true;
                AtRet[] atr = this.parseBaseActionAttributes(attrs);
                String id = NVDLSAXReader.this.uniqueActionID(attrs);
                NVDLResultAction a = new NVDLResultAction(id, atr[0].value, 3, this.baseRule);
                this.baseRule.getActionManager().setResultAction(a);
                this.parseActionBase(a, atr[1].value);
            } else {
                super.startElement(uri, localName, qName, attrs);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            if (!(this.cancelNestedActions || this.noResultAction || this.resultAction)) {
                NVDLSAXReader.this.readInvalidError("NVDLReader.NoActionError");
            }
        }

        ActionsHandler(BaseHandler bh, NVDLRule baseRule) {
            super(bh);
            this.cancelNestedActions = false;
            this.noResultAction = false;
            this.resultAction = false;
            this.baseRule = baseRule;
        }
    }

    static class AtRet {
        String name;
        String value;

        AtRet(String name) {
            this.name = name;
            this.value = null;
        }
    }

    private class BaseHandler
    extends DefaultHandler {
        private final BaseHandler ph;

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            NVDLSAXReader.this.prefixMapper.startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            NVDLSAXReader.this.prefixMapper.endPrefixMapping(prefix);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            NVDLSAXReader.this.readUnknownError("NVDLReader.UnallowedCharactersError", new Object[]{new String(ch, start, length)});
        }

        public void setDocumentLocator(Locator locator) {
            NVDLSAXReader.this.locator = locator;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            NVDLSAXReader.this.readUnknownError("NVDLReader.UnallowedElementError", new Object[]{uri, qName});
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.ph != null) {
                NVDLSAXReader.this.setHandler(this.ph);
            }
        }

        BaseHandler(BaseHandler prev) {
            this.ph = prev;
        }
    }

    private class ContextHandler
    extends WSSkipHandler {
        private final NVDLAction action;
        private NVDLMode mode;
        private final String useModeName;
        private final String path;

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (NVDLSAXReader.this.isForeign(uri)) {
                NVDLSAXReader.this.setHandler(new ForeignSkipHandler(this));
                return;
            }
            if (localName.equals("mode")) {
                if (this.useModeName != null) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.ContextHasModeButUseModeIsSpecifiedError");
                }
                this.mode = NVDLSAXReader.this.parseNestedMode(this, attrs);
            } else {
                super.startElement(uri, localName, qName, attrs);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            try {
                if (this.mode == null) {
                    if (this.useModeName == null) {
                        NVDLSAXReader.this.readInvalidError("NVDLReader.ContextHasUseModeOrModeError");
                    }
                    this.action.addContext(this.path, this.useModeName);
                } else {
                    this.action.addContext(this.path, this.mode);
                }
            }
            catch (NVDLException e) {
                NVDLSAXReader.this.readInvalidError(e.getMessage());
            }
        }

        ContextHandler(BaseHandler bh, NVDLAction action, String path, String useModeName) {
            super(bh);
            this.action = action;
            this.path = path;
            this.useModeName = useModeName;
        }
    }

    private class ForeignSkipHandler
    extends BaseHandler {
        private int level;

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++this.level;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            --this.level;
            if (this.level <= 0) {
                super.endElement(uri, localName, qName);
            }
        }

        ForeignSkipHandler(BaseHandler bh) {
            super(bh);
            this.level = 1;
        }
    }

    private class InitialHandler
    extends WSSkipHandler {
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (NVDLSAXReader.this.isForeign(uri) || !localName.equals("rules")) {
                NVDLSAXReader.this.readUnknownError("NVDLReader.DocumentElementIsRulesError", new Object[]{uri, qName});
                return;
            }
            AtRet[] ars = new AtRet[]{new AtRet("schemaType"), new AtRet("startMode")};
            NVDLSAXReader.this.getAttrs(attrs, ars);
            NVDLSAXReader.this.rules = new NVDLRules(ars[0].value, ars[1].value);
            NVDLSAXReader.this.setLocation(NVDLSAXReader.this.rules);
            NVDLSAXReader.this.setHandler(new RulesHandler(this));
        }

        InitialHandler() {
            super(null);
        }
    }

    private class MessageHandler
    extends BaseHandler {
        private final NVDLMessage nm;
        private final String lang;
        private StringBuffer buf;

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buf.append(ch, start, length);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            this.nm.addMessage(this.lang, this.buf.toString());
        }

        MessageHandler(BaseHandler bh, NVDLMessage nm, String lang) {
            super(bh);
            this.buf = new StringBuffer();
            this.nm = nm;
            this.lang = lang;
        }
    }

    private class ModeHandler
    extends RuleHandler {
        private final NVDLMode mode;
        private static final int INITIAL = 0;
        private static final int INCLUDEDMODE_APPEARED = 1;
        private static final int RULE_APPEARED = 2;
        private int modeState;

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (NVDLSAXReader.this.isForeign(uri)) {
                NVDLSAXReader.this.setHandler(new ForeignSkipHandler(this));
                return;
            }
            if (localName.equals("mode")) {
                if (this.modeState > 1) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.IncludedModeAfterRuleError");
                }
                NVDLSAXReader.this.parseIncludedMode(this, attrs, this.mode);
                this.modeState = 1;
            } else {
                NVDLRule rule = this.parseRule(localName, attrs);
                if (rule == null) {
                    super.startElement(uri, localName, qName, attrs);
                } else {
                    NVDLSAXReader.this.addRule(this.mode, rule);
                    this.modeState = 2;
                }
            }
        }

        ModeHandler(BaseHandler bh, NVDLMode mode) {
            super(bh);
            this.modeState = 0;
            this.mode = mode;
        }
    }

    private abstract class RuleHandler
    extends WSSkipHandler {
        private boolean targetElement;
        private boolean targetAttribute;

        private void parseMatchTarget(String mt) throws SAXException {
            if (mt.equals("elements")) {
                this.targetElement = true;
            } else if (mt.equals("attributes")) {
                this.targetAttribute = true;
            } else {
                NVDLSAXReader.this.readInvalidError("NVDLReader.InvalidMatchTargetError", new Object[]{mt});
            }
        }

        private NVDLRule createRuleModel(boolean any, String ns, char wildCard, String target) throws SAXException {
            this.targetAttribute = false;
            this.targetElement = false;
            if (target == null) {
                this.targetElement = true;
            } else {
                String[] targets = NVDLSAXReader.this.splitList(target);
                if (targets.length == 0) {
                    this.targetElement = true;
                } else if (targets.length == 1) {
                    this.parseMatchTarget(targets[0]);
                } else if (targets.length == 2) {
                    this.parseMatchTarget(targets[0]);
                    this.parseMatchTarget(targets[1]);
                } else {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.InvalidMatchTargetError", new Object[]{target});
                }
            }
            NVDLRule rule = new NVDLRule(any, ns, wildCard, this.targetElement, this.targetAttribute);
            NVDLSAXReader.this.setLocation(rule);
            return rule;
        }

        protected NVDLRule parseRule(String localName, Attributes attrs) throws SAXException {
            if (localName.equals("namespace")) {
                AtRet[] ars = new AtRet[]{new AtRet("ns"), new AtRet("wildCard"), new AtRet("match")};
                NVDLSAXReader.this.getAttrs(attrs, ars);
                char wildCardChar = '*';
                if (ars[1].value != null) {
                    if (ars[1].value.length() == 0) {
                        wildCardChar = '\u0000';
                    } else if (ars[1].value.length() == 1) {
                        wildCardChar = ars[1].value.charAt(0);
                    } else {
                        NVDLSAXReader.this.readInvalidError("NVDLReader.WildCardOneCharError", new Object[]{ars[1].value});
                    }
                }
                NVDLRule rule = this.createRuleModel(false, ars[0].value, wildCardChar, ars[2].value);
                NVDLSAXReader.this.parseRuleActions(this, rule);
                return rule;
            }
            if (localName.equals("anyNamespace")) {
                AtRet[] ars = new AtRet[]{new AtRet("match")};
                NVDLSAXReader.this.getAttrs(attrs, ars);
                NVDLRule rule = this.createRuleModel(true, null, ' ', ars[0].value);
                NVDLSAXReader.this.parseRuleActions(this, rule);
                return rule;
            }
            return null;
        }

        RuleHandler(BaseHandler bh) {
            super(bh);
            this.targetElement = false;
            this.targetAttribute = false;
        }
    }

    private class RulesHandler
    extends RuleHandler {
        private static final int INITIAL = 0;
        private static final int TRIGGER_APPEARED = 1;
        private static final int RULE_APPEARED = 2;
        private static final int MODE_APPEARED = 3;
        private int rulesState;

        private void parseTrigger(Attributes attrs) throws SAXException {
            AtRet[] ars = new AtRet[]{new AtRet("ns"), new AtRet("nameList")};
            NVDLSAXReader.this.getAttrs(attrs, ars);
            if (ars[0].value == null) {
                NVDLSAXReader.this.readInvalidError("NVDLReader.TriggerHasNSError");
            }
            if (ars[1].value == null) {
                NVDLSAXReader.this.readInvalidError("NVDLReader.TriggerHasNameListError");
            }
            NVDLSAXReader.this.rules.getTriggerManager().addTrigger(ars[0].value, NVDLSAXReader.this.splitList(ars[1].value));
            NVDLSAXReader.this.setHandler(new WSSkipHandler(this));
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (NVDLSAXReader.this.isForeign(uri)) {
                NVDLSAXReader.this.setHandler(new ForeignSkipHandler(this));
                return;
            }
            if (localName.equals("trigger")) {
                if (this.rulesState > 1) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.TriggerIsFirstError");
                }
                this.rulesState = 1;
                this.parseTrigger(attrs);
            } else if (localName.equals("mode")) {
                if (this.rulesState == 2) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.ModeIsAfterRuleError");
                }
                this.rulesState = 3;
                NVDLSAXReader.this.parseMode(this, attrs);
            } else {
                NVDLMode mode;
                NVDLRule rule = this.parseRule(localName, attrs);
                if (rule == null) {
                    super.startElement(uri, localName, qName, attrs);
                    return;
                }
                if (this.rulesState == 3) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.RuleIsAfterModeError", new Object[]{localName});
                }
                this.rulesState = 2;
                if (NVDLSAXReader.this.rules.getStartModeName() != null) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.StartModeError");
                }
                if ((mode = NVDLSAXReader.this.rules.getStartMode()) == null) {
                    mode = new NVDLMode("nested start mode ");
                    mode.setLocation(rule.getLocation());
                    NVDLSAXReader.this.rules.setStartMode(mode);
                }
                NVDLSAXReader.this.addRule(mode, rule);
            }
        }

        RulesHandler(BaseHandler bh) {
            super(bh);
            this.rulesState = 0;
        }
    }

    private class SchemaHandler
    extends WSSkipHandler {
        private NVDLValidateAction action;
        private int level;
        private SchemaFactory schemaFactory;
        private SchemaReaderProxy proxyForSchemaAttribute;
        private SchemaReaderProxy proxyForSchemaElement;

        public void setDocumentLocator(Locator locator) {
            if (this.proxyForSchemaAttribute != null) {
                this.proxyForSchemaAttribute.setDocumentLocator(locator);
            }
            if (this.proxyForSchemaElement != null) {
                this.proxyForSchemaElement.setDocumentLocator(locator);
            }
            super.setDocumentLocator(locator);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.level == 0) {
                Log.debug("Try to create schemaFactory for " + uri);
                try {
                    this.schemaFactory = SchemaFactory.newInstance(uri);
                    this.schemaFactory.setErrorHandler(NVDLSAXReader.this.eh);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.SchemaImplementationNotFoundError", new Object[]{uri});
                    return;
                }
                if (this.proxyForSchemaAttribute != null) {
                    this.proxyForSchemaAttribute.begin(this.schemaFactory, new InputSource(NVDLSAXReader.this.locator.getSystemId()), uri, true);
                }
                if (this.proxyForSchemaElement != null) {
                    this.proxyForSchemaElement.begin(this.schemaFactory, new InputSource(NVDLSAXReader.this.locator.getSystemId()), uri, false);
                }
            }
            if (this.proxyForSchemaAttribute != null) {
                this.proxyForSchemaAttribute.startElement(uri, localName, qName, attributes);
            }
            if (this.proxyForSchemaElement != null) {
                this.proxyForSchemaElement.startElement(uri, localName, qName, attributes);
            }
            ++this.level;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.proxyForSchemaAttribute != null) {
                this.proxyForSchemaAttribute.characters(ch, start, length);
            }
            if (this.proxyForSchemaElement != null) {
                this.proxyForSchemaElement.characters(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.level == 0) {
                if (this.proxyForSchemaAttribute != null) {
                    this.proxyForSchemaAttribute.end();
                    if (this.proxyForSchemaAttribute.getSchema() == null) {
                        NVDLSAXReader.this.readInvalidError("NVDLReader.SchemaReadError");
                    }
                    this.action.setSchema(this.proxyForSchemaAttribute.getSchema(), true);
                }
                if (this.proxyForSchemaElement != null) {
                    this.proxyForSchemaElement.end();
                    if (this.proxyForSchemaElement.getSchema() == null) {
                        NVDLSAXReader.this.readInvalidError("NVDLReader.SchemaReadError");
                    }
                    this.action.setSchema(this.proxyForSchemaElement.getSchema(), false);
                }
                super.endElement(uri, localName, qName);
            } else {
                if (this.proxyForSchemaAttribute != null) {
                    this.proxyForSchemaAttribute.endElement(uri, localName, qName);
                }
                if (this.proxyForSchemaElement != null) {
                    this.proxyForSchemaElement.endElement(uri, localName, qName);
                }
                --this.level;
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            super.startPrefixMapping(prefix, uri);
            if (this.proxyForSchemaAttribute != null) {
                this.proxyForSchemaAttribute.startPrefixMapping(prefix, uri);
            }
            if (this.proxyForSchemaElement != null) {
                this.proxyForSchemaElement.startPrefixMapping(prefix, uri);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            super.endPrefixMapping(prefix);
            if (this.proxyForSchemaAttribute != null) {
                this.proxyForSchemaAttribute.endPrefixMapping(prefix);
            }
            if (this.proxyForSchemaElement != null) {
                this.proxyForSchemaElement.endPrefixMapping(prefix);
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (this.proxyForSchemaAttribute != null) {
                this.proxyForSchemaAttribute.processingInstruction(target, data);
            }
            if (this.proxyForSchemaElement != null) {
                this.proxyForSchemaElement.processingInstruction(target, data);
            }
        }

        SchemaHandler(BaseHandler bh, NVDLValidateAction action) {
            super(bh);
            this.action = action;
            this.level = 0;
            if (action.getBelongingRule().isTargetAttribute()) {
                this.proxyForSchemaAttribute = SchemaReaderProxy.newProxy(NVDLSAXReader.this.locator, NVDLSAXReader.this.prefixMapper);
                this.proxyForSchemaAttribute.setErrorHandler(NVDLSAXReader.this.eh);
            }
            if (action.getBelongingRule().isTargetElement()) {
                this.proxyForSchemaElement = SchemaReaderProxy.newProxy(NVDLSAXReader.this.locator, NVDLSAXReader.this.prefixMapper);
                this.proxyForSchemaElement.setErrorHandler(NVDLSAXReader.this.eh);
            }
        }
    }

    private class ValidateHandler
    extends ActionBaseHandler {
        private final NVDLValidateAction validateAction;

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (NVDLSAXReader.this.isForeign(uri)) {
                super.startElement(uri, localName, qName, attrs);
            } else if (localName.equals("option")) {
                if (this.actionBaseState > 1) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.OptionBeforeSchemaError");
                }
                this.actionBaseState = 1;
                AtRet[] ars = new AtRet[]{new AtRet("name"), new AtRet("arg"), new AtRet("mustSupport")};
                NVDLSAXReader.this.getAttrs(attrs, ars);
                if (ars[0].value == null) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.OptionHasNameError");
                }
                boolean mustSupport = NVDLSAXReader.this.parseXSDBoolean(ars[2].value, false);
                this.validateAction.addOption(ars[0].value, ars[1].value, mustSupport);
                NVDLSAXReader.this.setHandler(new WSSkipHandler(this));
            } else if (localName.equals("schema")) {
                if (this.validateAction.getSchemaIRI() != null) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.SchemaAttributeSpecifiedError");
                }
                if (this.actionBaseState > 2) {
                    NVDLSAXReader.this.readInvalidError("NVDLReader.SchemaBeforeModeOrContextError");
                }
                this.actionBaseState = 2;
                NVDLSAXReader.this.parseSchema(this, this.validateAction, attrs);
            } else {
                super.startElement(uri, localName, qName, attrs);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            if (!this.validateAction.isSchamaSpecified()) {
                NVDLSAXReader.this.readInvalidError("NVDLReader.ValidateHasSchemaError");
            }
        }

        ValidateHandler(BaseHandler bh, NVDLValidateAction action) {
            super(bh, action);
            this.validateAction = action;
        }
    }

    private class WSSkipHandler
    extends BaseHandler {
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!NVDLSAXReader.this.checkWhiteSpace(ch, start, length)) {
                NVDLSAXReader.this.readUnknownError("NVDLReader.UnallowedCharactersError", new Object[]{new String(ch, start, length)});
            }
        }

        WSSkipHandler(BaseHandler bh) {
            super(bh);
        }
    }
}

