/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.as;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.model.flash.as.ASObject;

public class ASDeserializer {
    private static final Map<String, Object> tokenDic = new HashMap<String, Object>();
    private static final Object UNDEFINED = "undefined".intern();
    private static final Object NULL = "null".intern();
    private int idx = 0;
    private String str;

    static {
        tokenDic.put("true", true);
        tokenDic.put("false", false);
        tokenDic.put("undefined", UNDEFINED);
        tokenDic.put("null", NULL);
    }

    private int skipSP() {
        while (this.idx < this.str.length()) {
            char ch = this.str.charAt(this.idx);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.idx;
                    break;
                }
                default: {
                    return this.idx;
                }
            }
        }
        return -1;
    }

    private int getTokenEndIdx() {
        int idx2 = this.idx;
        while (idx2 < this.str.length()) {
            char ch = this.str.charAt(idx2);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    return idx2;
                }
            }
            ++idx2;
        }
        return idx2;
    }

    private String deserializeString() {
        StringBuffer ret = new StringBuffer();
        ++this.idx;
        while (this.idx < this.str.length()) {
            char ch = this.str.charAt(this.idx);
            switch (ch) {
                case '\"': {
                    ++this.idx;
                    return ret.toString();
                }
                case '\\': {
                    ++this.idx;
                    if (this.idx == this.str.length()) {
                        throw new IllegalArgumentException("Abnormal end of the string:" + this.str);
                    }
                    ret.append(this.str.charAt(this.idx));
                    ++this.idx;
                    break;
                }
                default: {
                    ret.append(ch);
                    ++this.idx;
                }
            }
        }
        throw new IllegalArgumentException("Invalid String:" + this.str);
    }

    private Object[] deserializeArray() {
        ++this.idx;
        ArrayList<Object> ret = new ArrayList<Object>();
        while (this.idx < this.str.length()) {
            this.skipSP();
            char ch = this.str.charAt(this.idx);
            if (ch == ']') {
                ++this.idx;
                return ret.toArray(new Object[ret.size()]);
            }
            ret.add(this.deserialize());
            this.skipSP();
            ch = this.str.charAt(this.idx);
            if (ch == ']') {
                ++this.idx;
                return ret.toArray(new Object[ret.size()]);
            }
            if (ch != ',') {
                throw new IllegalArgumentException("Missing ',':" + this.str);
            }
            ++this.idx;
        }
        throw new IllegalArgumentException("Abnormal end of the array:" + this.str);
    }

    private ASObject deserializeASObject() {
        ++this.idx;
        ASObject ret = new ASObject();
        while (this.idx < this.str.length()) {
            this.skipSP();
            char ch = this.str.charAt(this.idx);
            if (ch == '}') {
                ++this.idx;
                return ret;
            }
            String prop = this.deserializeString();
            this.skipSP();
            if (this.str.charAt(this.idx) != ':') {
                throw new IllegalArgumentException("Missing ':':" + this.str);
            }
            ++this.idx;
            Object o = this.deserialize();
            ret.put(prop, o);
            this.skipSP();
            ch = this.str.charAt(this.idx);
            if (ch == '}') {
                ++this.idx;
                return ret;
            }
            if (this.str.charAt(this.idx) != ',') {
                throw new IllegalArgumentException("Missing ',':" + this.str);
            }
            ++this.idx;
        }
        throw new IllegalArgumentException("Abnormal end of the array:" + this.str);
    }

    public Object deserialize() {
        int r = this.skipSP();
        if (r < 0) {
            return null;
        }
        char ch = this.str.charAt(this.idx);
        switch (ch) {
            case '[': {
                return this.deserializeArray();
            }
            case '{': {
                return this.deserializeASObject();
            }
            case '\"': {
                return this.deserializeString();
            }
        }
        int idx2 = this.getTokenEndIdx();
        String tok = this.str.substring(this.idx, idx2);
        Object o = tokenDic.get(tok);
        this.idx = idx2;
        if (o == NULL) {
            return null;
        }
        if (o != null) {
            return o;
        }
        try {
            int i = Integer.parseInt(tok);
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(tok);
                return new Double(d);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new IllegalArgumentException(String.valueOf(tok) + " is not a valid token.");
            }
        }
    }

    public ASDeserializer(String str) {
        this.str = str;
    }
}

