/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ui.text.blocks.AmbiguousBlockSet;
import org.eclipse.dltk.ui.text.blocks.Block;
import org.eclipse.dltk.ui.text.blocks.BlockSet;
import org.eclipse.dltk.ui.text.blocks.IBlockSet;
import org.eclipse.dltk.ui.text.blocks.Keyword;
import org.eclipse.dltk.ui.text.blocks.MultiHashMapWithHashSet;
import org.eclipse.dltk.ui.text.blocks.SingleBlockSet;

public class BlocksConfiguration {
    private static final boolean DEBUG_BLOCKS_INTERSECTION = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.ui/blocks/debugIntersection"));
    private Pattern beginMiddleEndPattern;
    private Pattern middleEndAlignedPattern;
    private Map singleBlockSets = new HashMap();
    private Map multiBlockSets = new HashMap();
    private Map wordsToKeywords = new HashMap();
    private IBlockSet rootBlockSet;

    public BlocksConfiguration(Block[] blocks) {
        MultiHashMapWithHashSet allNames = new MultiHashMapWithHashSet();
        int i = 0;
        while (i < blocks.length) {
            Block block = blocks[i];
            block.install(allNames);
            ++i;
        }
        Iterator iter = allNames.keySet().iterator();
        while (iter.hasNext()) {
            Keyword keyword = (Keyword)iter.next();
            this.wordsToKeywords.put(keyword.getText(), keyword);
        }
        HashSet<Block> rootBlocks = new HashSet<Block>();
        rootBlocks.addAll(Arrays.asList(blocks));
        this.rootBlockSet = this.createBlockSet(rootBlocks);
        int lastBlockSetsCount = 0;
        int currentBlockSetsCount = this.singleBlockSets.size() + this.multiBlockSets.size();
        int index = 0;
        while (currentBlockSetsCount > lastBlockSetsCount) {
            ArrayList all = new ArrayList(currentBlockSetsCount);
            all.addAll(this.singleBlockSets.values());
            all.addAll(this.multiBlockSets.values());
            Iterator iter1 = all.iterator();
            while (iter1.hasNext()) {
                BlockSet leftBlockSet = (BlockSet)iter1.next();
                HashSet<Block> leftBlocks = new HashSet<Block>();
                leftBlocks.addAll(Arrays.asList(leftBlockSet.getBlocks()));
                if (DEBUG_BLOCKS_INTERSECTION) {
                    System.out.println("Intersecting " + leftBlockSet);
                }
                Iterator iter2 = all.iterator();
                while (iter2.hasNext()) {
                    BlockSet rightBlockSet = (BlockSet)iter2.next();
                    HashSet<Block> rightBlocks = new HashSet<Block>();
                    if (DEBUG_BLOCKS_INTERSECTION) {
                        System.out.print("   with " + rightBlockSet + "    #" + index++);
                    }
                    rightBlocks.addAll(Arrays.asList(rightBlockSet.getBlocks()));
                    rightBlocks.retainAll(leftBlocks);
                    if (!rightBlocks.isEmpty()) {
                        IBlockSet blockSet = this.createBlockSet(rightBlocks);
                        if (DEBUG_BLOCKS_INTERSECTION) {
                            System.out.println(" = " + blockSet);
                        }
                        leftBlockSet.putIntersection(rightBlockSet, blockSet);
                        continue;
                    }
                    if (!DEBUG_BLOCKS_INTERSECTION) continue;
                    System.out.println(" = \u00c3\u00b8");
                }
            }
            lastBlockSetsCount = currentBlockSetsCount;
            currentBlockSetsCount = this.singleBlockSets.size() + this.multiBlockSets.size();
        }
        this.beginMiddleEndPattern = BlocksConfiguration.createBeginMiddleEndPattern(blocks);
        this.middleEndAlignedPattern = BlocksConfiguration.createMiddleEndAlignedPattern(blocks);
    }

    private IBlockSet createBlockSet(Set blocks) {
        BlockSet blockSet;
        if (blocks.isEmpty()) {
            return IBlockSet.EMPTY;
        }
        if (blocks.size() == 1) {
            Block block = (Block)blocks.iterator().next();
            SingleBlockSet result = (SingleBlockSet)this.singleBlockSets.get(block);
            if (result != null) {
                return result;
            }
            result = new SingleBlockSet(block);
            this.singleBlockSets.put(block, result);
            blockSet = result;
        } else {
            AmbiguousBlockSet result = (AmbiguousBlockSet)this.multiBlockSets.get(blocks);
            if (result != null) {
                return result;
            }
            Block[] array = new Block[blocks.size()];
            blocks.toArray(array);
            result = new AmbiguousBlockSet(array);
            this.multiBlockSets.put(blocks, result);
            blockSet = result;
        }
        HashMap<Keyword, IBlockSet> narrowings = new HashMap<Keyword, IBlockSet>();
        Iterator iter = this.wordsToKeywords.values().iterator();
        while (iter.hasNext()) {
            Keyword incomingKeyword = (Keyword)iter.next();
            HashSet<Block> narrowBlocks = new HashSet<Block>();
            Iterator iterator = blocks.iterator();
            while (iterator.hasNext()) {
                Block block = (Block)iterator.next();
                if (!BlocksConfiguration.blockAllowsKeyword(block, incomingKeyword)) continue;
                narrowBlocks.add(block);
            }
            if (narrowBlocks.isEmpty()) continue;
            narrowings.put(incomingKeyword, this.createBlockSet(narrowBlocks));
        }
        blockSet.setKeywordsToBlockSets(narrowings);
        return blockSet;
    }

    public static boolean blockAllowsKeyword(Block block, Keyword keyword) {
        if (block.getBeginning() == keyword || block.getEnding() == keyword) {
            return true;
        }
        Keyword[] middleKeywords = block.getMiddleKeywords();
        int i = 0;
        while (i < middleKeywords.length) {
            if (middleKeywords[i] == keyword) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Pattern createBeginMiddleEndPattern(Block[] blocks) {
        HashSet<String> components = new HashSet<String>();
        int i = 0;
        while (i < blocks.length) {
            Block block = blocks[i];
            components.add(block.getBeginningRegularExpression());
            components.addAll(block.getMiddleRegularExpressions());
            components.add(block.getEndingRegularExpression());
            ++i;
        }
        String regexp = BlocksConfiguration.join(components);
        return Pattern.compile(regexp);
    }

    private static Pattern createMiddleEndAlignedPattern(Block[] blocks) {
        HashSet<String> components = new HashSet<String>();
        int i = 0;
        while (i < blocks.length) {
            Block block = blocks[i];
            components.addAll(block.getMiddleRegularExpressions());
            components.add(block.getEndingRegularExpression());
            ++i;
        }
        String regexp = "^(?:" + BlocksConfiguration.join(components) + ")";
        return Pattern.compile(regexp);
    }

    private static String join(Set components) {
        StringBuffer regex = new StringBuffer();
        regex.append("(?:");
        boolean first = true;
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            String component = (String)iter.next();
            if (first) {
                first = false;
            } else {
                regex.append("|");
            }
            regex.append(component);
        }
        regex.append(")");
        String regexp = regex.toString();
        return regexp;
    }

    public Pattern getBeginMiddleEndPattern() {
        return this.beginMiddleEndPattern;
    }

    public Pattern getMiddleEndAlignedPattern() {
        return this.middleEndAlignedPattern;
    }

    public IBlockSet getRootBlockSet() {
        return this.rootBlockSet;
    }

    public Keyword getKeyword(String word) {
        return (Keyword)this.wordsToKeywords.get(word);
    }
}

